/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.akanamonsanto.core;

import ar.com.sdd.akanamonsanto.core.AkanaMonsantoSecurityManager;
import ar.com.sdd.akanamonsanto.io.ConsultaFinanciacionErrorResponse;
import ar.com.sdd.akanamonsanto.io.ConsultaFinanciacionRequest;
import ar.com.sdd.akanamonsanto.io.ConsultaFinanciacionResponse;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import org.apache.log4j.Logger;

public class AkanaMonsantoConnector {
    private static final Logger log = Logger.getLogger(AkanaMonsantoConnector.class);
    private final AkanaMonsantoSecurityManager securityManager;
    private final RestConnectorEnvironment environment;
    private final RestConnector restConnector;

    public AkanaMonsantoConnector(String clientId, String clientSecret, String scope, String userPass, String tokenUrl, String baseUrl) {
        log.trace((Object)("Inicializando AkanaMonsantoConnector con clientId:[" + clientId + "], clientSecret:[" + clientSecret + "], scope:[" + scope + "], userPass:[" + userPass + "], tokenUrl:[" + tokenUrl + "], baseUrl:[" + baseUrl + "]"));
        this.securityManager = new AkanaMonsantoSecurityManager(clientId, clientSecret, scope, userPass, tokenUrl);
        this.environment = new RestConnectorEnvironment();
        this.environment.baseUrl = baseUrl;
        this.restConnector = new RestConnector(this.environment, (RestSecurityManager)this.securityManager);
    }

    public ConsultaFinanciacionResponse consultaFinanciacion(ConsultaFinanciacionRequest request) throws RestConnectorException {
        log.trace((Object)("ConsultandaFinanciacion request [" + request + "]"));
        this.securityManager.requestXCSRFTokenForThisPost(this.environment.baseUrl + "/financiacion");
        ConsultaFinanciacionResponse response = (ConsultaFinanciacionResponse)this.restConnector.genericPost((Object)request, ConsultaFinanciacionResponse.class, ConsultaFinanciacionErrorResponse.class, "/financiacion");
        log.trace((Object)("ConsultandaFinanciacion response [" + response + "]"));
        return response;
    }
}

