/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.akanamonsanto.core;

import ar.com.sdd.akanamonsanto.io.TokenOAuth2Response;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AkanaMonsantoSecurityManager
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(AkanaMonsantoSecurityManager.class);
    private final String clientId;
    private final String clientSecret;
    private final String scope;
    private final String userPass;
    private final String tokenUrl;
    private String pathToRequestXCSRFTokenForThisPost;

    public AkanaMonsantoSecurityManager(String clientId, String clientSecret, String scope, String userPass, String tokenUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.userPass = userPass;
        this.tokenUrl = tokenUrl;
    }

    public boolean retryOnUnauthorized() {
        try {
            this.getAccessToken(true);
            return true;
        }
        catch (RestConnectorException e) {
            log.error((Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        String token = this.getAccessToken(false);
        log.trace("Token recuperado [" + token + "]");
        if (!StringUtils.isEmpty((CharSequence)this.pathToRequestXCSRFTokenForThisPost)) {
            log.trace("Recuperando XCSRF para el path [" + this.pathToRequestXCSRFTokenForThisPost + "]");
            RestConnectorEnvironment environment = new RestConnectorEnvironment();
            environment.baseUrl = this.pathToRequestXCSRFTokenForThisPost;
            this.pathToRequestXCSRFTokenForThisPost = null;
            RestConnector connector = new RestConnector(environment, null);
            try (Response postResponseHeaders = null;){
                postResponseHeaders = connector.buildRequest(environment.baseUrl, null).header("Authorization", (Object)("Bearer " + token + ", Basic " + this.userPass)).header("X-CSRF-Token", (Object)"Fetch").get();
                String headerXCSRFToken = postResponseHeaders.getHeaderString("x-csrf-token");
                builder.header("X-CSRF-Token", (Object)headerXCSRFToken);
                log.trace("HeaderXCSRFToken [" + headerXCSRFToken + "]");
                Map cookies = postResponseHeaders.getCookies();
                for (NewCookie cookie : cookies.values()) {
                    log.trace("Cookie [" + cookie + "]");
                    builder.cookie((Cookie)cookie);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)token)) {
            builder.header("Authorization", (Object)("Bearer " + token + ", Basic " + this.userPass));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public void requestXCSRFTokenForThisPost(String path) {
        this.pathToRequestXCSRFTokenForThisPost = path;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(AkanaMonsantoSecurityManager.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("client_id", this.clientId);
            form.param("client_secret", this.clientSecret);
            form.param("scope", this.scope);
            form.param("grant_type", "client_credentials");
            log.trace("Por recuperar token Azure con clientId [" + this.clientId + "], clientSecret [" + this.clientSecret + "], scope [" + this.scope + "]");
            RestConnectorEnvironment environment = new RestConnectorEnvironment();
            environment.baseUrl = this.tokenUrl;
            RestConnector connector = new RestConnector(environment, null);
            TokenOAuth2Response tokenOAuth2Response = (TokenOAuth2Response)connector.genericPost((Object)form, TokenOAuth2Response.class, "", "application/json", "application/x-www-form-urlencoded");
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, (Object)accessToken, Integer.valueOf(tokenOAuth2Response.getExpiresIn() - 10));
        }
        return accessToken;
    }
}

