import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class DocumentData {

    private LocalDate date;
    private LocalDate creationDate;
    private String docType;
    private String legalDocRef;
    private String payerDocRef;
    private BigDecimal amount0;
    private BigDecimal amount1;
    private BigDecimal amount2;
    private BigDecimal amount3;
    private BigDecimal subTotal;
    private BigDecimal subTotal1;
    private BigDecimal subTotal2;
    private BigDecimal subTotal3;
    private BigDecimal totalAmount;

    public LocalDate getDate() {
        return date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getDocType() {
        return docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getPayerDocRef() {
        return payerDocRef;
    }

    public void setPayerDocRef(String payerDocRef) {
        this.payerDocRef = payerDocRef;
    }

    public BigDecimal getAmount() {
        return amount0;
    }

    public void setAmount0(BigDecimal amount0) {
        this.amount0 = amount0;
    }

    public BigDecimal getAmount1() {
        return amount1;
    }

    public void setAmount1(BigDecimal amount1) {
        this.amount1 = amount1;
    }

    public BigDecimal getAmount2() {
        return amount2;
    }

    public void setAmount2(BigDecimal amount2) {
        this.amount2 = amount2;
    }

    public BigDecimal getAmount3() {
        return amount3;
    }

    public void setAmount3(BigDecimal amount3) {
        this.amount3 = amount3;
    }

    public BigDecimal getSubTotal() {
        return subTotal;
    }

    public void setSubTotal(BigDecimal subTotal) {
        this.subTotal = subTotal;
    }

    public BigDecimal getSubTotal1() {
        return subTotal1;
    }

    public void setSubTotal1(BigDecimal subTotal1) {
        this.subTotal1 = subTotal1;
    }

    public BigDecimal getSubTotal2() {
        return subTotal2;
    }

    public void setSubTotal2(BigDecimal subTotal2) {
        this.subTotal2 = subTotal2;
    }

    public BigDecimal getSubTotal3() {
        return subTotal3;
    }

    public void setSubTotal3(BigDecimal subTotal3) {
        this.subTotal3 = subTotal3;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocumentData that = (DocumentData) o;
        return Objects.equals(date, that.date) &&
                Objects.equals(creationDate, that.creationDate) &&
                Objects.equals(docType, that.docType) &&
                Objects.equals(legalDocRef, that.legalDocRef) &&
                Objects.equals(payerDocRef, that.payerDocRef) &&
                Objects.equals(amount0, that.amount0) &&
                Objects.equals(amount1, that.amount1) &&
                Objects.equals(amount2, that.amount2) &&
                Objects.equals(amount3, that.amount3) &&
                Objects.equals(subTotal, that.subTotal) &&
                Objects.equals(subTotal1, that.subTotal1) &&
                Objects.equals(subTotal2, that.subTotal2) &&
                Objects.equals(subTotal3, that.subTotal3) &&
                Objects.equals(totalAmount, that.totalAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, creationDate, docType, legalDocRef, payerDocRef, amount0, amount1, amount2, amount3, subTotal, subTotal1, subTotal2, subTotal3, totalAmount);
    }

    @Override
    public String toString() {
        return "DocumentData ["
                + ((date != null) ? "date=" + date + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((docType != null) ? "docType=" + docType + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((payerDocRef != null) ? "payerDocRef=" + payerDocRef + ", " : "")
                + ((amount0 != null) ? "amount0=" + amount0 + ", " : "")
                + ((amount1 != null) ? "amount1=" + amount1 + ", " : "")
                + ((amount2 != null) ? "amount2=" + amount2 + ", " : "")
                + ((amount3 != null) ? "amount3=" + amount3 + ", " : "")
                + ((subTotal != null) ? "subTotal=" + subTotal + ", " : "")
                + ((subTotal1 != null) ? "subTotal1=" + subTotal1 + ", " : "")
                + ((subTotal2 != null) ? "subTotal2=" + subTotal2 + ", " : "")
                + ((subTotal3 != null) ? "subTotal3=" + subTotal3 + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount : "")
                + "]";
    }
}
