import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.*;

public class FavoritaListenerImp extends FavoritaBaseListener{
    private DocumentData dpgData;
    private DocumentData docData;
    private Map<String, DocumentData> payments;
    private Map<String, List<DocumentData>> payable;
    private Map<String, List<DocumentData>> deductions;
    private Map<String, List<DocumentData>> retentions;
    private Map<String, List<DocumentData>> instruments;


    @Override
    public void enterLotePago(FavoritaParser.LotePagoContext ctx) {
        dpgData = new DocumentData();
        deductions = new HashMap<>();
        payable = new HashMap<>();
        retentions = new HashMap<>();
        instruments = new HashMap<>();
        payments = new HashMap<>();
    }

    @Override
    public void exitHeaderLinea9(FavoritaParser.HeaderLinea9Context ctx) {
        dpgData.setPayerDocRef(ctx.NUMBER().getText());
        dpgData.setLegalDocRef(ctx.NUMBER().getText());
    }

    @Override
    public void exitHeaderLinea10(FavoritaParser.HeaderLinea10Context ctx) {
        LocalDate creationDate = LocalDate.parse(ctx.DATE().toString());
        dpgData.setCreationDate(creationDate);
        String amount = ctx.AMOUNT().getText();
        try {
            BigDecimal amountFormatted = formatAmountToBigDecimal(amount);
            dpgData.setTotalAmount(amountFormatted);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println("DPG: " + dpgData.toString());
    }


    @Override
    public void enterDetalleLine(FavoritaParser.DetalleLineContext ctx) {
        docData = new DocumentData();
    }


    @Override
    public void exitDetalleLine(FavoritaParser.DetalleLineContext ctx) {

        try {

            LocalDate localDate = LocalDate.parse(ctx.DATE().getText());
            docData.setDate(localDate);

            String legalDocRef = ctx.NUMBER(1).toString();
            docData.setLegalDocRef(legalDocRef);



            docData.setAmount0(formatAmountToBigDecimal(ctx.AMOUNT(0).toString()));
            docData.setAmount1(formatAmountToBigDecimal(ctx.AMOUNT(1).toString()));
            docData.setAmount2(formatAmountToBigDecimal(ctx.AMOUNT(2).toString()));
            docData.setAmount3(formatAmountToBigDecimal(ctx.AMOUNT(3).toString()));

            String docType = ctx.WORD(0).toString();
            if(docType.startsWith("DV")) {
                docType = "DED";
                docData.setDocType(docType);
                addDocumentToMap(dpgData.getPayerDocRef(), docData, deductions);
            }else if(docType.startsWith("PV") || docType.startsWith("NC")) {
                docType = "PAC";
                docData.setDocType(docType);
                payments.put(dpgData.getPayerDocRef(), docData);
            }else if(docType.startsWith("RT")) {
                docType = "RET";
                docData.setDocType(docType);
                addDocumentToMap(dpgData.getPayerDocRef(), docData, retentions);
            }else {
                docType = "DED";

                //TODO
            }
            System.out.println(docData.toString());

        }catch (Exception e) {
            e.printStackTrace();
        }
    }


    private BigDecimal formatAmountToBigDecimal(String amount) throws ParseException{
        amount =  amount.replaceAll("[$)]", "").replaceAll("[(]", "-").trim();
        NumberFormat numberFormat = NumberFormat.getInstance( new Locale("en", "US"));
        Number numberFormatted = numberFormat.parse(amount);
        return new BigDecimal( numberFormatted.doubleValue()).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    private void addDocumentToMap(String key, DocumentData document, Map<String, List<DocumentData>> map) {
        List<DocumentData> documentList =  map.computeIfPresent(key, (k,documentDataList) -> {
            documentDataList.add(document);
            return documentDataList;
        });

        if (documentList == null) {
            documentList = new ArrayList<>();
            map.put(key, documentList);
            documentList.add(document);
        }
    }


    public DocumentData getDpgData() {
        return dpgData;
    }

    public void setDpgData(DocumentData dpgData) {
        this.dpgData = dpgData;
    }

    public DocumentData getDocData() {
        return docData;
    }

    public void setDocData(DocumentData docData) {
        this.docData = docData;
    }

    public Map<String, DocumentData> getPayments() {
        return payments;
    }

    public void setPayments(Map<String, DocumentData> payments) {
        this.payments = payments;
    }

    public Map<String, List<DocumentData>> getPayable() {
        return payable;
    }

    public void setPayable(Map<String, List<DocumentData>> payable) {
        this.payable = payable;
    }

    public Map<String, List<DocumentData>> getDeductions() {
        return deductions;
    }

    public void setDeductions(Map<String, List<DocumentData>> deductions) {
        this.deductions = deductions;
    }

    public Map<String, List<DocumentData>> getRetentions() {
        return retentions;
    }

    public void setRetentions(Map<String, List<DocumentData>> retentions) {
        this.retentions = retentions;
    }

    public Map<String, List<DocumentData>> getInstruments() {
        return instruments;
    }

    public void setInstruments(Map<String, List<DocumentData>> instruments) {
        this.instruments = instruments;
    }
}
