/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FavoritaListenerImp
extends FavoritaBaseListener {
    private DocumentData dpgData;
    private DocumentData docData;
    private Map<String, DocumentData> payments;
    private Map<String, List<DocumentData>> payable;
    private Map<String, List<DocumentData>> deductions;
    private Map<String, List<DocumentData>> retentions;
    private Map<String, List<DocumentData>> instruments;

    @Override
    public void enterLotePago(FavoritaParser.LotePagoContext ctx) {
        this.dpgData = new DocumentData();
        this.deductions = new HashMap<String, List<DocumentData>>();
        this.payable = new HashMap<String, List<DocumentData>>();
        this.retentions = new HashMap<String, List<DocumentData>>();
        this.instruments = new HashMap<String, List<DocumentData>>();
        this.payments = new HashMap<String, DocumentData>();
    }

    @Override
    public void exitHeaderLinea9(FavoritaParser.HeaderLinea9Context ctx) {
        this.dpgData.setPayerDocRef(ctx.NUMBER().getText());
        this.dpgData.setLegalDocRef(ctx.NUMBER().getText());
    }

    @Override
    public void exitHeaderLinea10(FavoritaParser.HeaderLinea10Context ctx) {
        LocalDate creationDate = LocalDate.parse(ctx.DATE().toString());
        this.dpgData.setCreationDate(creationDate);
        String amount = ctx.AMOUNT().getText();
        try {
            BigDecimal amountFormatted = this.formatAmountToBigDecimal(amount);
            this.dpgData.setTotalAmount(amountFormatted);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println("DPG: " + this.dpgData.toString());
    }

    @Override
    public void enterDetalleLine(FavoritaParser.DetalleLineContext ctx) {
        this.docData = new DocumentData();
    }

    @Override
    public void exitDetalleLine(FavoritaParser.DetalleLineContext ctx) {
        try {
            LocalDate localDate = LocalDate.parse(ctx.DATE().getText());
            this.docData.setDate(localDate);
            String legalDocRef = ctx.NUMBER(1).toString();
            this.docData.setLegalDocRef(legalDocRef);
            this.docData.setAmount0(this.formatAmountToBigDecimal(ctx.AMOUNT(0).toString()));
            this.docData.setAmount1(this.formatAmountToBigDecimal(ctx.AMOUNT(1).toString()));
            this.docData.setAmount2(this.formatAmountToBigDecimal(ctx.AMOUNT(2).toString()));
            this.docData.setAmount3(this.formatAmountToBigDecimal(ctx.AMOUNT(3).toString()));
            String docType = ctx.WORD(0).toString();
            if (docType.startsWith("DV")) {
                docType = "DED";
                this.docData.setDocType(docType);
                this.addDocumentToMap(this.dpgData.getPayerDocRef(), this.docData, this.deductions);
            } else if (docType.startsWith("PV") || docType.startsWith("NC")) {
                docType = "PAC";
                this.docData.setDocType(docType);
                this.payments.put(this.dpgData.getPayerDocRef(), this.docData);
            } else if (docType.startsWith("RT")) {
                docType = "RET";
                this.docData.setDocType(docType);
                this.addDocumentToMap(this.dpgData.getPayerDocRef(), this.docData, this.retentions);
            } else {
                docType = "DED";
            }
            System.out.println(this.docData.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BigDecimal formatAmountToBigDecimal(String amount) throws ParseException {
        amount = amount.replaceAll("[$)]", "").replaceAll("[(]", "-").trim();
        NumberFormat numberFormat = NumberFormat.getInstance(new Locale("en", "US"));
        Number numberFormatted = numberFormat.parse(amount);
        return new BigDecimal(numberFormatted.doubleValue()).setScale(2, 4);
    }

    private void addDocumentToMap(String key, DocumentData document, Map<String, List<DocumentData>> map) {
        ArrayList<DocumentData> documentList = map.computeIfPresent(key, (k, documentDataList) -> {
            documentDataList.add(document);
            return documentDataList;
        });
        if (documentList == null) {
            documentList = new ArrayList<DocumentData>();
            map.put(key, documentList);
            documentList.add(document);
        }
    }

    public DocumentData getDpgData() {
        return this.dpgData;
    }

    public void setDpgData(DocumentData dpgData) {
        this.dpgData = dpgData;
    }

    public DocumentData getDocData() {
        return this.docData;
    }

    public void setDocData(DocumentData docData) {
        this.docData = docData;
    }

    public Map<String, DocumentData> getPayments() {
        return this.payments;
    }

    public void setPayments(Map<String, DocumentData> payments) {
        this.payments = payments;
    }

    public Map<String, List<DocumentData>> getPayable() {
        return this.payable;
    }

    public void setPayable(Map<String, List<DocumentData>> payable) {
        this.payable = payable;
    }

    public Map<String, List<DocumentData>> getDeductions() {
        return this.deductions;
    }

    public void setDeductions(Map<String, List<DocumentData>> deductions) {
        this.deductions = deductions;
    }

    public Map<String, List<DocumentData>> getRetentions() {
        return this.retentions;
    }

    public void setRetentions(Map<String, List<DocumentData>> retentions) {
        this.retentions = retentions;
    }

    public Map<String, List<DocumentData>> getInstruments() {
        return this.instruments;
    }

    public void setInstruments(Map<String, List<DocumentData>> instruments) {
        this.instruments = instruments;
    }
}

