/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.antlrparser;

import ar.com.sdd.antlrparser.FavoritaBaseListener;
import ar.com.sdd.antlrparser.FavoritaParser;
import ar.com.sdd.antlrparser.ParserDocumentData;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FavoritaListenerImp
extends FavoritaBaseListener {
    private ParserDocumentData dpgData;
    private ParserDocumentData docData;
    private Map<String, ParserDocumentData> payments;
    private Map<String, List<ParserDocumentData>> payable;
    private Map<String, List<ParserDocumentData>> deductions;
    private Map<String, List<ParserDocumentData>> retentions;
    private Map<String, List<ParserDocumentData>> instruments;

    @Override
    public void enterLotePago(FavoritaParser.LotePagoContext ctx) {
        this.dpgData = new ParserDocumentData();
        this.deductions = new HashMap<String, List<ParserDocumentData>>();
        this.payable = new HashMap<String, List<ParserDocumentData>>();
        this.retentions = new HashMap<String, List<ParserDocumentData>>();
        this.instruments = new HashMap<String, List<ParserDocumentData>>();
        this.payments = new HashMap<String, ParserDocumentData>();
    }

    @Override
    public void exitHeaderLinea8(FavoritaParser.HeaderLinea8Context ctx) {
        this.dpgData.setIssuerBank(ctx.getChild(1).getText());
    }

    @Override
    public void exitHeaderLinea9(FavoritaParser.HeaderLinea9Context ctx) {
        this.dpgData.setPayerDocRef(ctx.NUMBER().getText());
        this.dpgData.setLegalDocRef(ctx.NUMBER().getText());
    }

    @Override
    public void exitHeaderLinea10(FavoritaParser.HeaderLinea10Context ctx) {
        LocalDate creationDate = LocalDate.parse(ctx.DATE().toString());
        this.dpgData.setCreationDate(creationDate);
        String dueAmount = ctx.AMOUNT().getText();
        try {
            BigDecimal dueAmountFormatted = this.formatAmountToBigDecimal(dueAmount);
            this.dpgData.setDueAmount(dueAmountFormatted);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void enterDetalleLine(FavoritaParser.DetalleLineContext ctx) {
        this.docData = new ParserDocumentData();
    }

    @Override
    public void exitDetalleLine(FavoritaParser.DetalleLineContext ctx) {
        try {
            LocalDate localDate = LocalDate.parse(ctx.DATE().getText());
            this.docData.setDate(localDate);
            String legalDocRef = ctx.NUMBER(1).toString();
            this.docData.setLegalDocRef(legalDocRef);
            this.docData.setPayerDocRef(legalDocRef);
            this.docData.setTotalAmount(this.formatAmountToBigDecimal(ctx.AMOUNT(0).toString()));
            this.docData.setAmount1(this.formatAmountToBigDecimal(ctx.AMOUNT(1).toString()));
            this.docData.setAmount2(this.formatAmountToBigDecimal(ctx.AMOUNT(2).toString()));
            this.docData.setDueAmount(this.formatAmountToBigDecimal(ctx.AMOUNT(3).toString()));
            String docType = ctx.WORD(0).toString();
            if (docType.startsWith("DV")) {
                docType = "DED";
            } else if (docType.startsWith("PV") || docType.startsWith("NC")) {
                docType = "PAC";
            } else if (docType.startsWith("RT")) {
                docType = "RET";
            }
            this.docData.setDocType(docType);
            this.addDocumentToMap(this.dpgData.getPayerDocRef(), this.docData, this.payable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exitFooterPago(FavoritaParser.FooterPagoContext ctx) {
        String totalAmount = ctx.AMOUNT().getText();
        try {
            BigDecimal amountFormatted = this.formatAmountToBigDecimal(totalAmount);
            this.dpgData.setTotalAmount(amountFormatted);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println(ctx.AMOUNT().getText());
    }

    @Override
    public void exitLotePago(FavoritaParser.LotePagoContext ctx) {
        System.out.println("DPG= " + this.dpgData.toString());
    }

    private BigDecimal formatAmountToBigDecimal(String amount) throws ParseException {
        amount = amount.replaceAll("[$)]", "").replaceAll("[(]", "-").trim();
        NumberFormat numberFormat = NumberFormat.getInstance(new Locale("en", "US"));
        Number numberFormatted = numberFormat.parse(amount);
        return new BigDecimal(numberFormatted.doubleValue()).setScale(2, 4);
    }

    private void addDocumentToMap(String key, ParserDocumentData document, Map<String, List<ParserDocumentData>> map) {
        ArrayList<ParserDocumentData> documentList = map.computeIfPresent(key, (k, documentDataList) -> {
            documentDataList.add(document);
            return documentDataList;
        });
        if (documentList == null) {
            documentList = new ArrayList<ParserDocumentData>();
            map.put(key, documentList);
            documentList.add(document);
        }
    }

    public ParserDocumentData getDpgData() {
        return this.dpgData;
    }

    public void setDpgData(ParserDocumentData dpgData) {
        this.dpgData = dpgData;
    }

    public ParserDocumentData getDocData() {
        return this.docData;
    }

    public void setDocData(ParserDocumentData docData) {
        this.docData = docData;
    }

    public Map<String, ParserDocumentData> getPayments() {
        return this.payments;
    }

    public void setPayments(Map<String, ParserDocumentData> payments) {
        this.payments = payments;
    }

    public Map<String, List<ParserDocumentData>> getPayable() {
        return this.payable;
    }

    public void setPayable(Map<String, List<ParserDocumentData>> payable) {
        this.payable = payable;
    }

    public Map<String, List<ParserDocumentData>> getDeductions() {
        return this.deductions;
    }

    public void setDeductions(Map<String, List<ParserDocumentData>> deductions) {
        this.deductions = deductions;
    }

    public Map<String, List<ParserDocumentData>> getRetentions() {
        return this.retentions;
    }

    public void setRetentions(Map<String, List<ParserDocumentData>> retentions) {
        this.retentions = retentions;
    }

    public Map<String, List<ParserDocumentData>> getInstruments() {
        return this.instruments;
    }

    public void setInstruments(Map<String, List<ParserDocumentData>> instruments) {
        this.instruments = instruments;
    }
}

