package ar.com.sdd.antlrparser;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class ParserDocumentData {

    private LocalDate dueDate;
    private LocalDate creationDate;
    private String docType;
    private String ownerDocType;
    private String legalDocRef;
    private String payerDocRef;
    private BigDecimal amount0;
    private BigDecimal amount1;
    private BigDecimal amount2;
    private BigDecimal amount3;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private String issuerBank;
    private String reasonName;
    private String lineNumber;

    public LocalDate getDueDate() {
        return dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public LocalDate getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getDocType() {
        return docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getPayerDocRef() {
        return payerDocRef;
    }

    public void setPayerDocRef(String payerDocRef) {
        this.payerDocRef = payerDocRef;
    }

    public BigDecimal getAmount0() {
        return amount0;
    }

    public void setAmount0(BigDecimal amount0) {
        this.amount0 = amount0;
    }

    public BigDecimal getAmount1() {
        return amount1;
    }

    public void setAmount1(BigDecimal amount1) {
        this.amount1 = amount1;
    }

    public BigDecimal getAmount2() {
        return amount2;
    }

    public void setAmount2(BigDecimal amount2) {
        this.amount2 = amount2;
    }

    public BigDecimal getAmount3() {
        return amount3;
    }

    public void setAmount3(BigDecimal amount3) {
        this.amount3 = amount3;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }


    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getIssuerBank() {
        return issuerBank;
    }

    public void setIssuerBank(String issuerBank) {
        this.issuerBank = issuerBank;
    }

    public String getReasonName() {
        return reasonName;
    }

    public void setReasonName(String reasonName) {
        this.reasonName = reasonName;
    }

    public String getLineNumber() {
        return lineNumber;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getOwnerDocType() {
        return ownerDocType;
    }

    public void setOwnerDocType(String ownerDocType) {
        this.ownerDocType = ownerDocType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ParserDocumentData that = (ParserDocumentData) o;
        return Objects.equals(dueDate, that.dueDate) &&
                Objects.equals(creationDate, that.creationDate) &&
                Objects.equals(docType, that.docType) &&
                Objects.equals(legalDocRef, that.legalDocRef) &&
                Objects.equals(payerDocRef, that.payerDocRef) &&
                Objects.equals(amount0, that.amount0) &&
                Objects.equals(amount1, that.amount1) &&
                Objects.equals(amount2, that.amount2) &&
                Objects.equals(amount3, that.amount3) &&
                Objects.equals(totalAmount, that.totalAmount) &&
                Objects.equals(dueAmount, that.dueAmount) &&
                Objects.equals(issuerBank, that.issuerBank) &&
                Objects.equals(reasonName, that.reasonName) &&
                Objects.equals(lineNumber, that.lineNumber);
    }

    @Override
    public int hashCode() {

        return Objects.hash(dueDate, creationDate, docType, legalDocRef, payerDocRef, amount0, amount1, amount2, amount3, totalAmount, dueAmount, issuerBank, reasonName, lineNumber);
    }

    @Override
    public String toString() {
        return "ParserDocumentData ["
                + ((dueDate != null) ? "date=" + dueDate + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((docType != null) ? "docType=" + docType + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((payerDocRef != null) ? "payerDocRef=" + payerDocRef + ", " : "")
                + ((amount0 != null) ? "amount0=" + amount0 + ", " : "")
                + ((amount1 != null) ? "amount1=" + amount1 + ", " : "")
                + ((amount2 != null) ? "amount2=" + amount2 + ", " : "")
                + ((amount3 != null) ? "amount3=" + amount3 + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "")
                + ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "")
                + ((issuerBank != null) ? "issuerBank=" + issuerBank + ", " : "")
                + ((reasonName != null) ? "reasonName=" + reasonName : "")
                + ((lineNumber != null) ? "lineNumber=" + lineNumber : "")
                + "]";
    }
}
