package ar.com.sdd.antlrparser;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

import java.io.*;

public class Cadenas {


    public static void main(String[] args) {
        CharStream inputStream = null;
        try {
            InputStream pdfInputStream = new FileInputStream("C:/Users/Dinho/Documents/sdd.pdf");


            PDDocument pdDocument = PDDocument.load(pdfInputStream);
            String text = "";
            if(!pdDocument.isEncrypted()) {
                PDFTextStripper stripper = new PDFTextStripper();
                text = stripper.getText(pdDocument);
                System.out.println(text);
            }

            InputStream stream = new ByteArrayInputStream(text.getBytes());

            System.out.println();

            inputStream = CharStreams.fromStream(stream);
            pdDocument.close();
        } catch (IOException e) {
            e.printStackTrace();
        }





        FavoritaLexer lexer = new FavoritaLexer( inputStream);
        FavoritaParser parser = new FavoritaParser( new CommonTokenStream( lexer ));
        ParseTree tree = parser.lotePago();

        FavoritaListenerImp listenerImp = new FavoritaListenerImp();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk( listenerImp, tree );
        listenerImp.getPayable().forEach( (k,v) -> v.forEach(System.err::println) );



    }


}
