package ar.com.sdd.avnapi.client.model;

import ar.com.sdd.avnapi.client.io.AvnDocument;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostPaymentInfraccionRequest implements Serializable {

    // TODO: Capaz tendria que ser un InfraccionDocument en vez de un AvnDocument

    @JsonProperty("documents")
    @ArraySchema(
            schema = @Schema(),
            arraySchema = @Schema(description = "Listado de documentos con los que armar el pago", requiredMode = Schema.RequiredMode.REQUIRED, example = "1bc5721a-e679-4ba5-b057-c2d7a517983a")
    )
    private List<AvnDocument> documents;

    public List<AvnDocument> getDocuments() {
        return documents;
    }

    public void setDocuments(List<AvnDocument> documents) {
        this.documents = documents;
    }

    @Override
    public String toString() {
        return "AvnPaymentRequest [" +
                ((documents != null) ? "avnDocuments=" + Arrays.toString(documents.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostPaymentInfraccionRequest that = (PostPaymentInfraccionRequest) o;
        return Objects.equals(documents, that.documents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(documents);
    }
}