package ar.com.sdd.avnapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostPaymentInfraccionResponse implements Serializable {

    @Schema(description = "Link para acceder a la orden de pago", requiredMode = Schema.RequiredMode.REQUIRED, example = "https://avn.sdd.com.ar/sdd.bepres/payer/common/api/ActionLinkGW.jsp?tokenpgw=abcdefgh-1234-5678-ijkl-mn90opqrstuv")
    private String paymentUrl;

    @Schema(description = "Tiempo de vigencia del link expresado en segundos", requiredMode = Schema.RequiredMode.REQUIRED, example = "60")
    private Integer expiresIn;

    public String getPaymentUrl() {
        return paymentUrl;
    }

    public void setPaymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "AvnPaymentResponse [" +
                ((paymentUrl != null) ? "paymentUrl='" + paymentUrl + "', " : "") +
                ((expiresIn != null) ? "expiresIn=" + expiresIn + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostPaymentInfraccionResponse that = (PostPaymentInfraccionResponse) o;
        return Objects.equals(paymentUrl, that.paymentUrl) && Objects.equals(expiresIn, that.expiresIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(paymentUrl, expiresIn);
    }
}