package ar.com.sdd.avnapi.client.model;

import ar.com.sdd.avnapi.client.io.AvnDocument;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostSelectExpensaLinkRequest implements Serializable {

    /**
     * Nombre de usuario a loguearse (operator.name)
     */
    @Schema(
            description = "Identificador de usuario. Es únicamente requerido para pagar expensas",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "1bc5721a-e679-4ba5-b057-c2d7a517983a o '00000' para el usuario anónimo"
    )
    private String userId;

    /**
     * Payer del documento (payerCode1)
     */
    @Schema(
            description = "ID de la Unidad Funcional de la cual se quieren visualizar Expensas",
            requiredMode = Schema.RequiredMode.NOT_REQUIRED,
            example = "20784"
    )
    private String unidadFuncional;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUnidadFuncional() {
        return unidadFuncional;
    }

    public void setUnidadFuncional(String unidadFuncional) {
        this.unidadFuncional = unidadFuncional;
    }

    @Override
    public String toString() {
        return "PostSelectExpensaLinkRequest [" +
                ((userId != null) ? "userId='" + userId + "', " : "") +
                ((unidadFuncional != null) ? "unidadFuncional='" + unidadFuncional + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostSelectExpensaLinkRequest that = (PostSelectExpensaLinkRequest) o;
        return Objects.equals(userId, that.userId) && Objects.equals(unidadFuncional, that.unidadFuncional);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId, unidadFuncional);
    }
}