package ar.com.sdd.avnapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostSelectExpensaLinkResponse implements Serializable {

    /**
     * Link hacia ActionLinkGW.jsp con un token para loguearse
     */
    @Schema(
            description = "Link para acceder a la plataforma y visualizar las expensas",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "https://avn.sdd.com.ar/sdd.bepres/payer/common/api/ActionLinkGW.jsp?tokenpgw=abcdefgh-1234-5678-ijkl-mn90opqrstuv"
    )
    private String selectExpensaLink;

    /**
     * Tiempo de expiracion del link expresado en segundos
     */
    @Schema(
            description = "Tiempo de vigencia del link expresado en segundos",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "60"
    )
    private Integer expiresIn;

    public PostSelectExpensaLinkResponse() {
    }

    public PostSelectExpensaLinkResponse(String selectExpensaLink, Integer expiresIn) {
        this.selectExpensaLink = selectExpensaLink;
        this.expiresIn = expiresIn;
    }

    public String getSelectExpensaLink() {
        return selectExpensaLink;
    }

    public void setSelectExpensaLink(String selectExpensaLink) {
        this.selectExpensaLink = selectExpensaLink;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "PostSelectExpensaLinkResponse [" +
                ((selectExpensaLink != null) ? "selectExpensaLink='" + selectExpensaLink + "', " : "") +
                ((expiresIn != null) ? "expiresIn=" + expiresIn + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostSelectExpensaLinkResponse that = (PostSelectExpensaLinkResponse) o;
        return Objects.equals(selectExpensaLink, that.selectExpensaLink) && Objects.equals(expiresIn, that.expiresIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(selectExpensaLink, expiresIn);
    }
}