package ar.com.sdd.avnapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostSsoLinkRequest implements Serializable {

    /**
     * Nombre de usuario a loguearse (operator.name)
     */
    @Schema(
            description = "Identificador de usuario",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "1bc5721a-e679-4ba5-b057-c2d7a517983a"
    )
    private String userId;

    /**
     * Filtro sobre payerCode1 o payer elegido. Se usa en conjunto con redirectToBalance, ya que aplica para NEXTBILLEXPIRATIONLST_PENDIENTES
     */
    @Schema(
            description = "ID de la Unidad Funcional. Si está definida, se redirige hacia la pantalla de Partidas filtrando por la unidad funcional solicitada",
            requiredMode = Schema.RequiredMode.NOT_REQUIRED,
            example = "20784"
    )
    private String unidadFuncional;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUnidadFuncional() {
        return unidadFuncional;
    }

    public void setUnidadFuncional(String unidadFuncional) {
        this.unidadFuncional = unidadFuncional;
    }

    @Override
    public String toString() {
        return "PostLoginRequest [" +
                ((userId != null) ? "gui='" + userId + "', " : "") +
                ((unidadFuncional != null) ? "unidadFuncional='" + unidadFuncional + "'" : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostSsoLinkRequest that = (PostSsoLinkRequest) o;
        return Objects.equals(userId, that.userId) && Objects.equals(unidadFuncional, that.unidadFuncional);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId, unidadFuncional);
    }
}