package ar.com.sdd.avnapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostSsoLinkResponse implements Serializable {

    /**
     * Link hacia ActionLinkGW.jsp con un token para loguearse
     */
    @Schema(
            description = "Link para acceder a la plataforma",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "https://avn.sdd.com.ar/sdd.bepres/payer/common/api/ActionLinkGW.jsp?tokenpgw=abcdefgh-1234-5678-ijkl-mn90opqrstuv"
    )
    private String ssoLink;

    /**
     * Tiempo de expiracion del link expresado en segundos
     */
    @Schema(
            description = "Tiempo de vigencia del link expresado en segundos",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "60"
    )
    private Integer expiresIn;

    public PostSsoLinkResponse() {
    }

    public PostSsoLinkResponse(String ssoLink, Integer expiresIn) {
        this.ssoLink = ssoLink;
        this.expiresIn = expiresIn;
    }

    public String getSsoLink() {
        return ssoLink;
    }

    public void setSsoLink(String ssoLink) {
        this.ssoLink = ssoLink;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "PostLoginResponse [" +
                ((ssoLink != null) ? "loginUrl='" + ssoLink + "', " : "") +
                ((expiresIn != null) ? "expiresIn=" + expiresIn : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostSsoLinkResponse that = (PostSsoLinkResponse) o;
        return Objects.equals(ssoLink, that.ssoLink) && Objects.equals(expiresIn, that.expiresIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ssoLink, expiresIn);
    }
}