package ar.com.sdd.avnapi.client.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AvnDocument implements Serializable {

    /**
     * Payer del documento (payerCode1)
     */
    @Schema(description = "ID de la Unidad Funcional", requiredMode = Schema.RequiredMode.NOT_REQUIRED, example = "20784")
    private String unidadFuncional;

    /**
     * OwnerDocRef del documento
     */
    @Schema(description = "Identificador de deuda", requiredMode = Schema.RequiredMode.REQUIRED, example = "1_20784_FC103000013756")
    private String identificadorDeuda;

    /**
     * OwnerType del documento
     */
    @Schema(description = "Tipo de deuda a pagar: 1 (Expensas), 2 (Expensa Acumulada), 3 (Infracción), 4 (Tag), 5 (Renovación de Tag)", allowableValues = {"1", "2", "3", "4", "5"}, requiredMode = Schema.RequiredMode.NOT_REQUIRED, example = "4")
    private String tipoDeuda;

    @Schema(description = "Importe", format = "double", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private BigDecimal importe;

    @Schema(description = "Descripcion", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String descripcion;

    public String getUnidadFuncional() {
        return unidadFuncional;
    }

    public void setUnidadFuncional(String unidadFuncional) {
        this.unidadFuncional = unidadFuncional;
    }

    public String getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(String identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    public String getTipoDeuda() {
        return tipoDeuda;
    }

    public void setTipoDeuda(String tipoDeuda) {
        this.tipoDeuda = tipoDeuda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Override
    public String toString() {
        return "AvnDocument [" +
                ((unidadFuncional != null) ? "unidadFuncional='" + unidadFuncional + "', " : "") +
                ((identificadorDeuda != null) ? "identificadorDeuda='" + identificadorDeuda + "', " : "") +
                ((tipoDeuda != null) ? "tipoDeuda='" + tipoDeuda + "', " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((descripcion != null) ? "descripcion='" + descripcion + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AvnDocument that = (AvnDocument) o;
        return Objects.equals(unidadFuncional, that.unidadFuncional) && Objects.equals(identificadorDeuda, that.identificadorDeuda) && Objects.equals(tipoDeuda, that.tipoDeuda) && Objects.equals(importe, that.importe) && Objects.equals(descripcion, that.descripcion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(unidadFuncional, identificadorDeuda, tipoDeuda, importe, descripcion);
    }
}