package ar.com.sdd.avnapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostSelectInfraccionLinkRequest implements Serializable {

    /**
     * Payer del documento (payerCode1)
     */
    @Schema(
            description = "Dominio del auto",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "AA379DX"
    )
    private String unidadFuncional;

    /**
     * OwnerDocRef del documento
     */
    @Schema(
            description = "Identificador de deuda",
            requiredMode = Schema.RequiredMode.NOT_REQUIRED,
            example = "3_6726"
    )
    private String identificadorDeuda;

    public String getUnidadFuncional() {
        return unidadFuncional;
    }

    public void setUnidadFuncional(String unidadFuncional) {
        this.unidadFuncional = unidadFuncional;
    }

    public String getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(String identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    @Override
    public String toString() {
        return "PostSelectInfraccionLinkRequest [" +
                ((unidadFuncional != null) ? "unidadFuncional='" + unidadFuncional + "', " : "") +
                ((identificadorDeuda != null) ? "identificadorDeuda='" + identificadorDeuda + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostSelectInfraccionLinkRequest that = (PostSelectInfraccionLinkRequest) o;
        return Objects.equals(unidadFuncional, that.unidadFuncional) && Objects.equals(identificadorDeuda, that.identificadorDeuda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(unidadFuncional, identificadorDeuda);
    }
}