package ar.com.sdd.avnapi.client.model;

import ar.com.sdd.avnapi.client.io.AvnDocument;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostPaymentInfraccionLinkRequest implements Serializable {

    /**
     * Payer del documento (payerCode1)
     */
    @Schema(
            description = "Dominio del auto",
            requiredMode = Schema.RequiredMode.NOT_REQUIRED,
            example = "AA379DX"
    )
    private String unidadFuncional;

    /**
     * OwnerDocRef del documento
     */
    @Schema(
            description = "Identificador de deuda",
            requiredMode = Schema.RequiredMode.NOT_REQUIRED,
            example = "3_6726"
    )
    private String identificadorDeuda;

    public String getUnidadFuncional() {
        return unidadFuncional;
    }

    public void setUnidadFuncional(String unidadFuncional) {
        this.unidadFuncional = unidadFuncional;
    }

    public String getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(String identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    @Override
    public String toString() {
        return "PostPaymentInfraccionLinkRequest [" +
                ((unidadFuncional != null) ? "unidadFuncional='" + unidadFuncional + "', " : "") +
                ((identificadorDeuda != null) ? "identificadorDeuda='" + identificadorDeuda + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostPaymentInfraccionLinkRequest that = (PostPaymentInfraccionLinkRequest) o;
        return Objects.equals(unidadFuncional, that.unidadFuncional) && Objects.equals(identificadorDeuda, that.identificadorDeuda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(unidadFuncional, identificadorDeuda);
    }
}