package ar.com.sdd.avnapi.client.model;

import ar.com.sdd.avnapi.client.io.AvnDocument;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostPaymentTagLinkRequest implements Serializable {

    private List<AvnDocument> documents;

    public List<AvnDocument> getDocuments() {
        return documents;
    }

    public void setDocuments(List<AvnDocument> documents) {
        this.documents = documents;
    }

    @Override
    public String toString() {
        return "PostPaymentTagLinkRequest [" +
                ((documents != null) ? "documents=" + Arrays.toString(documents.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostPaymentTagLinkRequest that = (PostPaymentTagLinkRequest) o;
        return Objects.equals(documents, that.documents);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(documents);
    }
}