/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.avnapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PostTokenizeCardRequest
implements Serializable {
    @Schema(description="Numero de tarjeta a tokenizar", requiredMode=Schema.RequiredMode.REQUIRED, example="5211222233334444")
    private String cardNumber;
    @Schema(description="Fecha de vencimiento de la tarjeta a tokenizar", format="MM/YY", requiredMode=Schema.RequiredMode.REQUIRED, example="12/25")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="MM/yy", timezone="GMT-03:00")
    private Date cardExpirationDate;

    public PostTokenizeCardRequest() {
    }

    public PostTokenizeCardRequest(String cardNumber, Date cardExpirationDate) {
        this.cardNumber = cardNumber;
        this.cardExpirationDate = cardExpirationDate;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public Date getCardExpirationDate() {
        return this.cardExpirationDate;
    }

    public void setCardExpirationDate(Date cardExpirationDate) {
        this.cardExpirationDate = cardExpirationDate;
    }

    public String toString() {
        return "PostTokenizeCardRequest [" + (String)(this.cardNumber != null ? "cardNumber='" + this.cardNumber + "', " : "") + (String)(this.cardExpirationDate != null ? "cardExpirationDate=" + this.cardExpirationDate + ", " : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTokenizeCardRequest that = (PostTokenizeCardRequest)o;
        return Objects.equals(this.cardNumber, that.cardNumber) && Objects.equals(this.cardExpirationDate, that.cardExpirationDate);
    }

    public int hashCode() {
        return Objects.hash(this.cardNumber, this.cardExpirationDate);
    }
}

