package ar.com.sdd.avnapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostSelectLinkResponse implements Serializable {

    /**
     * Link hacia ActionLinkGW.jsp con un token para loguearse
     */
    @Schema(
            description = "Link para acceder a la plataforma y visualizar las partidas solicitadas",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "https://avn.sdd.com.ar/sdd.bepres/payer/common/api/ActionLinkGW.jsp?tokenpgw=abcdefgh-1234-5678-ijkl-mn90opqrstuv"
    )
    private String selectLink;

    /**
     * Tiempo de expiracion del link expresado en segundos
     */
    @Schema(
            description = "Tiempo de vigencia del link expresado en segundos",
            requiredMode = Schema.RequiredMode.REQUIRED,
            example = "60"
    )
    private Integer expiresIn;

    public PostSelectLinkResponse() {
    }

    public PostSelectLinkResponse(String selectLink, Integer expiresIn) {
        this.selectLink = selectLink;
        this.expiresIn = expiresIn;
    }

    public String getSelectLink() {
        return selectLink;
    }

    public void setSelectLink(String selectLink) {
        this.selectLink = selectLink;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "PostSelectLinkResponse [" +
                ((selectLink != null) ? "selectLink='" + selectLink + "', " : "") +
                ((expiresIn != null) ? "expiresIn=" + expiresIn + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostSelectLinkResponse that = (PostSelectLinkResponse) o;
        return Objects.equals(selectLink, that.selectLink) && Objects.equals(expiresIn, that.expiresIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(selectLink, expiresIn);
    }
}