/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.avnapi.api.payment;

import ar.com.sdd.avnapi.api.payment.AvnPaymentApiService;
import ar.com.sdd.avnapi.client.model.PostPaymentExpensaLinkRequest;
import ar.com.sdd.avnapi.client.model.PostPaymentInfraccionLinkRequest;
import ar.com.sdd.avnapi.client.model.PostPaymentLinkResponse;
import ar.com.sdd.avnapi.client.model.PostPaymentTagLinkRequest;
import ar.com.sdd.avnapi.client.model.PostSelectExpensaLinkRequest;
import ar.com.sdd.avnapi.client.model.PostSelectInfraccionLinkRequest;
import ar.com.sdd.avnapi.client.model.PostSelectLinkResponse;
import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.ErrorResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/payment")
public class AvnPaymentApiEndpoint {
    @Inject
    private AvnPaymentApiService paymentApiService;

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment/select-expensa-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    @Operation(description="Genera un link para acceder a la plataforma y visualizar las expensas", responses={@ApiResponse(responseCode="200", description="Link de acceso a la plataforma", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostSelectLinkResponse.class))}), @ApiResponse(responseCode="401", description="No autorizado", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="400", description="Solicitud incorrecta", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="500", description="Error interno del servidor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    public Response postSelectExpensaLink(@Parameter(description="Token de autorizacion Bearer", required=true, in=ParameterIn.HEADER) @HeaderParam(value="Authorization") String authorization, @Parameter(description="ID de la aplicacion", required=true, in=ParameterIn.PATH) @PathParam(value="aid") String aid, @Parameter(description="ID de empresa", required=true, in=ParameterIn.PATH) @PathParam(value="ownerId") String ownerId, @Parameter(description="Usuario y unidad funcional sobre la cual ver las expensas", required=true) PostSelectExpensaLinkRequest postSelectExpensaLinkRequest, @Context SecurityContext securityContext) {
        return this.paymentApiService.postSelectExpensaLink(authorization, aid, ownerId, postSelectExpensaLinkRequest, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment/payment-expensa-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    @Operation(description="Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla", responses={@ApiResponse(responseCode="200", description="Link de pago generado correctamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostPaymentLinkResponse.class))}), @ApiResponse(responseCode="401", description="No autorizado", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="409", description="Conflicto de datos", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="400", description="Solicitud incorrecta", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="500", description="Error interno del servidor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    public Response postPaymentExpensaLink(@Parameter(description="Token de autorizacion Bearer", required=true, in=ParameterIn.HEADER) @HeaderParam(value="Authorization") String authorization, @Parameter(description="ID de la aplicacion", required=true, in=ParameterIn.PATH) @PathParam(value="aid") String aid, @Parameter(description="ID de empresa", required=true, in=ParameterIn.PATH) @PathParam(value="ownerId") String ownerId, @Parameter(description="Usuario y conjunto de expensas a pagar", required=true) PostPaymentExpensaLinkRequest postPaymentExpensaLinkRequest, @Context SecurityContext securityContext) {
        return this.paymentApiService.postPaymentExpensaLink(authorization, aid, ownerId, postPaymentExpensaLinkRequest, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment/select-infraccion-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    @Operation(description="Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla", responses={@ApiResponse(responseCode="200", description="Link de pago generado correctamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostSelectLinkResponse.class))}), @ApiResponse(responseCode="401", description="No autorizado", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="409", description="Conflicto de datos", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="400", description="Solicitud incorrecta", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="500", description="Error interno del servidor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    public Response postSelectInfraccionLink(@Parameter(description="Token de autorizacion Bearer", required=true, in=ParameterIn.HEADER) @HeaderParam(value="Authorization") String authorization, @Parameter(description="ID de la aplicacion", required=true, in=ParameterIn.PATH) @PathParam(value="aid") String aid, @Parameter(description="ID de empresa", required=true, in=ParameterIn.PATH) @PathParam(value="ownerId") String ownerId, @Parameter(description="Conjunto de documentos para generar el link de pago", required=true) PostSelectInfraccionLinkRequest postSelectInfraccionLinkRequest, @Context SecurityContext securityContext) {
        return this.paymentApiService.postSelectInfraccionLink(authorization, aid, ownerId, postSelectInfraccionLinkRequest, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment/payment-infraccion-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    @Operation(description="Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla", responses={@ApiResponse(responseCode="200", description="Link de pago generado correctamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostPaymentLinkResponse.class))}), @ApiResponse(responseCode="401", description="No autorizado", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="409", description="Conflicto de datos", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="400", description="Solicitud incorrecta", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="500", description="Error interno del servidor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    public Response postPaymentInfraccionLink(@Parameter(description="Token de autorizacion Bearer", required=true, in=ParameterIn.HEADER) @HeaderParam(value="Authorization") String authorization, @Parameter(description="ID de la aplicacion", required=true, in=ParameterIn.PATH) @PathParam(value="aid") String aid, @Parameter(description="ID de empresa", required=true, in=ParameterIn.PATH) @PathParam(value="ownerId") String ownerId, @Parameter(description="Conjunto de documentos para generar el link de pago", required=true) PostPaymentInfraccionLinkRequest documentSet, @Context SecurityContext securityContext) {
        return this.paymentApiService.postPaymentInfraccionLink(authorization, aid, ownerId, documentSet, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment/payment-tag-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    @Operation(description="Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla", responses={@ApiResponse(responseCode="200", description="Link de pago generado correctamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostPaymentLinkResponse.class))}), @ApiResponse(responseCode="401", description="No autorizado", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="409", description="Conflicto de datos", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="400", description="Solicitud incorrecta", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="500", description="Error interno del servidor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    public Response postPaymentTagLink(@Parameter(description="Token de autorizacion Bearer", required=true, in=ParameterIn.HEADER) @HeaderParam(value="Authorization") String authorization, @Parameter(description="ID de la aplicacion", required=true, in=ParameterIn.PATH) @PathParam(value="aid") String aid, @Parameter(description="ID de empresa", required=true, in=ParameterIn.PATH) @PathParam(value="ownerId") String ownerId, @Parameter(description="Conjunto de documentos para generar el link de pago", required=true) PostPaymentTagLinkRequest postPaymentTagLinkRequest, @Context SecurityContext securityContext) {
        return this.paymentApiService.postPaymentTagLink(authorization, aid, ownerId, postPaymentTagLinkRequest, securityContext);
    }
}

