package ar.com.sdd.avnapi.api.payment;

import ar.com.sdd.avnapi.client.model.*;
import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.ErrorResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/payment")
public class AvnPaymentApiEndpoint {

    @Inject
    private AvnPaymentApiService paymentApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment/select-expensa-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    @Operation(
            description = "Genera un link para acceder a la plataforma y visualizar las expensas",
            responses = {
                    @ApiResponse(responseCode = "200", description = "Link de acceso a la plataforma",
                            content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = PostSelectLinkResponse.class))),
                    @ApiResponse(responseCode = "401", description = "No autorizado", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "400", description = "Solicitud incorrecta", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "500", description = "Error interno del servidor", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class)))
            }
    )
    public Response postSelectExpensaLink(
            @Parameter(description = "Token de autorizacion Bearer", required = true, in = ParameterIn.HEADER)
            @HeaderParam("Authorization") String authorization,

            @Parameter(description = "ID de la aplicacion", required = true, in = ParameterIn.PATH)
            @PathParam("aid") String aid,

            @Parameter(description = "ID de empresa", required = true, in = ParameterIn.PATH)
            @PathParam("ownerId") String ownerId,

            @Parameter(description = "Usuario y unidad funcional sobre la cual ver las expensas", required = true)
            PostSelectExpensaLinkRequest postSelectExpensaLinkRequest,

            @Context SecurityContext securityContext
    ) {
        return paymentApiService.postSelectExpensaLink(authorization, aid, ownerId, postSelectExpensaLinkRequest, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment/payment-expensa-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    @Operation(
            description = "Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla",
            responses = {
                    @ApiResponse(responseCode = "200", description = "Link de pago generado correctamente",
                            content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = PostPaymentLinkResponse.class))),
                    @ApiResponse(responseCode = "401", description = "No autorizado", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "409", description = "Conflicto de datos", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "400", description = "Solicitud incorrecta", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "500", description = "Error interno del servidor", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class)))
            }
    )
    public Response postPaymentExpensaLink(
            @Parameter(description = "Token de autorizacion Bearer", required = true, in = ParameterIn.HEADER)
            @HeaderParam("Authorization") String authorization,

            @Parameter(description = "ID de la aplicacion", required = true, in = ParameterIn.PATH)
            @PathParam("aid") String aid,

            @Parameter(description = "ID de empresa", required = true, in = ParameterIn.PATH)
            @PathParam("ownerId") String ownerId,

            @Parameter(description = "Usuario y conjunto de expensas a pagar", required = true)
            PostPaymentExpensaLinkRequest postPaymentExpensaLinkRequest,

            @Context SecurityContext securityContext) {
        return paymentApiService.postPaymentExpensaLink(authorization, aid, ownerId, postPaymentExpensaLinkRequest, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment/select-infraccion-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    @Operation(
            description = "Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla",
            responses = {
                    @ApiResponse(responseCode = "200", description = "Link de pago generado correctamente",
                            content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = PostSelectLinkResponse.class))),
                    @ApiResponse(responseCode = "401", description = "No autorizado", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "409", description = "Conflicto de datos", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "400", description = "Solicitud incorrecta", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "500", description = "Error interno del servidor", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class)))
            }
    )
    public Response postSelectInfraccionLink(
            @Parameter(description = "Token de autorizacion Bearer", required = true, in = ParameterIn.HEADER)
            @HeaderParam("Authorization") String authorization,

            @Parameter(description = "ID de la aplicacion", required = true, in = ParameterIn.PATH)
            @PathParam("aid") String aid,

            @Parameter(description = "ID de empresa", required = true, in = ParameterIn.PATH)
            @PathParam("ownerId") String ownerId,

            @Parameter(description = "Conjunto de documentos para generar el link de pago", required = true)
            PostSelectInfraccionLinkRequest postSelectInfraccionLinkRequest,

            @Context SecurityContext securityContext) {
        return paymentApiService.postSelectInfraccionLink(authorization, aid, ownerId, postSelectInfraccionLinkRequest, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment/payment-infraccion-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    @Operation(
            description = "Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla",
            responses = {
                    @ApiResponse(responseCode = "200", description = "Link de pago generado correctamente",
                            content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = PostPaymentLinkResponse.class))),
                    @ApiResponse(responseCode = "401", description = "No autorizado", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "409", description = "Conflicto de datos", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "400", description = "Solicitud incorrecta", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "500", description = "Error interno del servidor", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class)))
            }
    )
    public Response postPaymentInfraccionLink(
            @Parameter(description = "Token de autorizacion Bearer", required = true, in = ParameterIn.HEADER)
            @HeaderParam("Authorization") String authorization,

            @Parameter(description = "ID de la aplicacion", required = true, in = ParameterIn.PATH)
            @PathParam("aid") String aid,

            @Parameter(description = "ID de empresa", required = true, in = ParameterIn.PATH)
            @PathParam("ownerId") String ownerId,

            @Parameter(description = "Conjunto de documentos para generar el link de pago", required = true)
            PostPaymentInfraccionLinkRequest documentSet,

            @Context SecurityContext securityContext) {
        return paymentApiService.postPaymentInfraccionLink(authorization, aid, ownerId, documentSet, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment/payment-tag-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    @Operation(
            description = "Arma una orden de pago con los documentos enviados en el request y devuelve un link para acceder a la misma y pagarla",
            responses = {
                    @ApiResponse(responseCode = "200", description = "Link de pago generado correctamente",
                            content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = PostPaymentLinkResponse.class))),
                    @ApiResponse(responseCode = "401", description = "No autorizado", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "409", description = "Conflicto de datos", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "400", description = "Solicitud incorrecta", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "500", description = "Error interno del servidor", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class)))
            }
    )
    public Response postPaymentTagLink(
            @Parameter(description = "Token de autorizacion Bearer", required = true, in = ParameterIn.HEADER)
            @HeaderParam("Authorization") String authorization,

            @Parameter(description = "ID de la aplicacion", required = true, in = ParameterIn.PATH)
            @PathParam("aid") String aid,

            @Parameter(description = "ID de empresa", required = true, in = ParameterIn.PATH)
            @PathParam("ownerId") String ownerId,

            @Parameter(description = "Conjunto de documentos para generar el link de pago", required = true)
            PostPaymentTagLinkRequest postPaymentTagLinkRequest,

            @Context SecurityContext securityContext) {
        return paymentApiService.postPaymentTagLink(authorization, aid, ownerId, postPaymentTagLinkRequest, securityContext);
    }
}