package ar.com.sdd.avnapi.api.login;

import ar.com.sdd.avnapi.client.model.PostSsoLinkRequest;
import ar.com.sdd.avnapi.client.model.PostSsoLinkResponse;
import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.ErrorResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/login")
public class AvnALoginApiEndpoint {

    @Inject
    private AvnLoginApiService avnLoginApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/sso-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    @Operation(
            description = "Genera un link para acceder a la plataforma asociado al usuario pasado como parametro en el request body",
            responses = {
                    @ApiResponse(responseCode = "200", description = "Link de acceso a la plataforma",
                            content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = PostSsoLinkResponse.class))),
                    @ApiResponse(responseCode = "401", description = "No autorizado", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "400", description = "Solicitud incorrecta", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class))),
                    @ApiResponse(responseCode = "500", description = "Error interno del servidor", content = @Content(mediaType = MediaType.APPLICATION_JSON, schema = @Schema(implementation = ErrorResult.class)))
            }
    )
    public Response postSsoLink(
            @Parameter(description = "Token de autorizacion Bearer", required = true, in = ParameterIn.HEADER)
            @HeaderParam("Authorization") String authorization,

            @Parameter(description = "ID de la aplicacion", required = true, in = ParameterIn.PATH)
            @PathParam("aid") String aid,

            @Parameter(description = "ID de empresa", required = true, in = ParameterIn.PATH)
            @PathParam("ownerId") String ownerId,

            @Parameter(description = "Información para obtener el link de acceso SSO", required = true)
            PostSsoLinkRequest postSsoLinkRequest,

            @Context SecurityContext securityContext
    ) {
        return avnLoginApiService.postSsoLink(authorization, aid, ownerId, postSsoLinkRequest, securityContext);
    }
}