package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Item implements Serializable {

    @JsonProperty("nombre")
    private String nombre;

    @JsonProperty("valor")
    private BigDecimal valor;

    public Item() {
    }

    public Item(String nombre, BigDecimal valor) {
        this.nombre = nombre;
        this.valor = valor;
    }

    public String getNombre() {
        return nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public BigDecimal getValor() {
        return valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Override
    public String toString() {
        return "Item [" +
                ((nombre != null) ? "nombre='" + nombre + "', " : "") +
                ((valor != null) ? "valor=" + valor + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Item item = (Item) o;
        return Objects.equals(nombre, item.nombre) && Objects.equals(valor, item.valor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nombre, valor);
    }
}