/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.bancoestadoapi.core;

import ar.com.sdd.bancoestadoapi.core.BancoEstadoApiConnectorContext;
import ar.com.sdd.bancoestadoapi.io.CreatePaymentIntentErrorResponse;
import ar.com.sdd.bancoestadoapi.io.CreatePaymentIntentRequest;
import ar.com.sdd.bancoestadoapi.io.CreatePaymentIntentResponse;
import ar.com.sdd.bancoestadoapi.io.PaymentReverseRequest;
import ar.com.sdd.bancoestadoapi.io.PaymentReverseResponse;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BancoEstadoApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(BancoEstadoApiConnector.class);
    private final RestConnector connector;
    private final String apiKey;
    private final String jwtSecret;

    public BancoEstadoApiConnector(BancoEstadoApiConnectorContext context) {
        this.apiKey = context.getApiKey();
        this.jwtSecret = context.getJwtSecret();
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.connector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public CreatePaymentIntentResponse createPaymentIntent(CreatePaymentIntentRequest request) throws RestConnectorException {
        String path = "/v5/intencionpago";
        log.debug("[createPaymentIntent] Request POST por crear intencion de pago con {} y path [{}]", (Object)request, (Object)"/v5/intencionpago");
        return (CreatePaymentIntentResponse)this.connector.genericPost((Object)request, CreatePaymentIntentResponse.class, CreatePaymentIntentErrorResponse.class, "/v5/intencionpago");
    }

    public PaymentReverseResponse paymentReverse(PaymentReverseRequest request) throws RestConnectorException {
        String path = "/v2/reversa";
        log.debug("[paymentReverse] Request POST por solicitar devolucion/reversar pago con {} y path [{}]", (Object)request, (Object)"/v2/reversa");
        return (PaymentReverseResponse)this.connector.genericPost((Object)request, PaymentReverseResponse.class, PaymentReverseResponse.class, "/v2/reversa");
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-api-key", (Object)this.apiKey);
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

