package ar.com.sdd.bancoestadoapi.core;

import ar.com.sdd.bancoestadoapi.io.*;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;

@SuppressWarnings("unused")
public class BancoEstadoApiConnector implements RestSecurityManager {

    private final static Logger log = LogManager.getLogger(BancoEstadoApiConnector.class);

    private final RestConnector connector;
    private final String apiKey;
    private final String jwtSecret;

    public BancoEstadoApiConnector(BancoEstadoApiConnectorContext context) {
        this.apiKey = context.getApiKey();
        this.jwtSecret = context.getJwtSecret();

        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        connector = new RestConnector(environment, this);
    }

    public CreatePaymentIntentResponse createPaymentIntent(CreatePaymentIntentRequest request) throws RestConnectorException {
        final String path = "/v5/intencionpago";
        log.debug("[createPaymentIntent] Request POST por crear intencion de pago con {} y path [{}]", request, path);
        return connector.genericPost(request, CreatePaymentIntentResponse.class, CreatePaymentIntentErrorResponse.class, path);
    }

    public PaymentReverseResponse paymentReverse(PaymentReverseRequest request) throws RestConnectorException {
        final String path = "/v2/reversa";
        log.debug("[paymentReverse] Request POST por solicitar devolucion/reversar pago con {} y path [{}]", request, path);
        return connector.genericPost(request, PaymentReverseResponse.class, PaymentReverseResponse.class, path);
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-api-key", this.apiKey);
        }
        return builder;
    }

    @Override
    public boolean retryOnUnauthorized() {
        return false;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}