package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreatePaymentIntentErrorResponse implements Serializable {

    @JsonProperty("msg")
    private String msg;

    @JsonProperty("code")
    private String code;

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "CreatePaymentIntentErrorResponse [" +
                ((msg != null) ? "msg='" + msg + "', " : "") +
                ((code != null) ? "code='" + code + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreatePaymentIntentErrorResponse that = (CreatePaymentIntentErrorResponse) o;
        return Objects.equals(msg, that.msg) && Objects.equals(code, that.code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(msg, code);
    }
}