package ar.com.sdd.bancoestadoapi.io;

import ar.com.sdd.bancoestadoapi.model.Item;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreatePaymentIntentRequest implements Serializable {

    @JsonProperty("comercio")
    private String comercio;

    @JsonProperty("oc")
    private String oc;

    @JsonProperty("total")
    private BigDecimal total;

    @JsonProperty("url_redirect")
    private String urlRedirect;

    @JsonProperty("url_respuesta")
    private String urlRespuesta;

    @JsonProperty("items")
    private List<Item> items;

    public String getComercio() {
        return comercio;
    }

    public void setComercio(String comercio) {
        this.comercio = comercio;
    }

    public String getOc() {
        return oc;
    }

    public void setOc(String oc) {
        this.oc = oc;
    }

    public BigDecimal getTotal() {
        return total;
    }

    // Este getter es el que se usara para serializar "total" ya que debe ir sin decimales
    @JsonGetter("total")
    public Long getTotalSinDecimales() {
        return total == null ? null : total.longValue();
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public String getUrlRedirect() {
        return urlRedirect;
    }

    public void setUrlRedirect(String urlRedirect) {
        this.urlRedirect = urlRedirect;
    }

    public String getUrlRespuesta() {
        return urlRespuesta;
    }

    public void setUrlRespuesta(String urlRespuesta) {
        this.urlRespuesta = urlRespuesta;
    }

    public List<Item> getItems() {
        return items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "CreatePaymentIntentRequest [" +
                ((comercio != null) ? "comercio='" + comercio + "', " : "") +
                ((oc != null) ? "oc='" + oc + "', " : "") +
                ((total != null) ? "total=" + total + ", " : "") +
                ((urlRedirect != null) ? "urlRedirect='" + urlRedirect + "', " : "") +
                ((urlRespuesta != null) ? "urlRespuesta='" + urlRespuesta + "', " : "") +
                ((items != null) ? "items=" + Arrays.toString(items.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreatePaymentIntentRequest that = (CreatePaymentIntentRequest) o;
        return Objects.equals(comercio, that.comercio) && Objects.equals(oc, that.oc) && Objects.equals(total, that.total) && Objects.equals(urlRedirect, that.urlRedirect) && Objects.equals(urlRespuesta, that.urlRespuesta) && Objects.equals(items, that.items);
    }

    @Override
    public int hashCode() {
        return Objects.hash(comercio, oc, total, urlRedirect, urlRespuesta, items);
    }
}