package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreatePaymentIntentResponse implements Serializable {

    @JsonProperty("urlCompraqui")
    private String urlCompraqui;

    @JsonProperty("jwt")
    private String jwt;

    public String getUrlCompraqui() {
        return urlCompraqui;
    }

    public void setUrlCompraqui(String urlCompraqui) {
        this.urlCompraqui = urlCompraqui;
    }

    public String getJwt() {
        return jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    @Override
    public String toString() {
        return "CreatePaymentIntentResponse [" +
                ((urlCompraqui != null) ? "urlCompraqui='" + urlCompraqui + "', " : "") +
                ((jwt != null) ? "jwt='" + jwt + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CreatePaymentIntentResponse that = (CreatePaymentIntentResponse) o;
        return Objects.equals(urlCompraqui, that.urlCompraqui) && Objects.equals(jwt, that.jwt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(urlCompraqui, jwt);
    }
}