package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentReverseRequest implements Serializable {

    @JsonProperty("token")
    private String token;

    @JsonProperty("refound")
    private Boolean refound;

    @JsonProperty("isTotal")
    private Boolean isTotal;

    @JsonProperty("mount")
    private BigDecimal mount;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getRefound() {
        return refound;
    }

    public void setRefound(Boolean refound) {
        this.refound = refound;
    }

    public Boolean getTotal() {
        return isTotal;
    }

    public void setTotal(Boolean total) {
        isTotal = total;
    }

    public BigDecimal getMount() {
        return mount;
    }

    public void setMount(BigDecimal mount) {
        this.mount = mount;
    }

    @Override
    public String toString() {
        return "PaymentReverseRequest [" +
                ((token != null) ? "token='" + token + "', " : "") +
                ((refound != null) ? "refound=" + refound + ", " : "") +
                ((isTotal != null) ? "isTotal=" + isTotal + ", " : "") +
                ((mount != null) ? "mount=" + mount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentReverseRequest that = (PaymentReverseRequest) o;
        return Objects.equals(token, that.token) && Objects.equals(refound, that.refound) && Objects.equals(isTotal, that.isTotal) && Objects.equals(mount, that.mount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(token, refound, isTotal, mount);
    }
}