package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cabecera implements Serializable {

    @JsonProperty("numerocuentacorriente")
    private String numeroCuentaCorriente;

    @JsonProperty("fechainicial")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy", timezone = "GMT-03:00")
    private Date fechaInicial;

    @JsonProperty("razonsocial")
    private String razonSocial;

    @JsonProperty("rut")
    private String rut;

    @JsonProperty("nombrecuenta")
    private String nombreCuenta;

    @JsonProperty("holding")
    private String holding;

    @JsonProperty("unidaddenegocio")
    private String unidadDeNegocio;

    @JsonProperty("usuarioconectado")
    private String usuarioConectado;

    @JsonProperty("rol")
    private String rol;

    @JsonProperty("fechahora")
    private String fechaHora;

    @JsonProperty("fechahoraemision")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy", timezone = "GMT-03:00")
    private String fechaHoraEmision;

    @JsonProperty("ejecutivo")
    private String ejecutivo;

    @JsonProperty("numeromovimientos")
    private Integer numeroMovimientos;

    @JsonProperty("numerocartola")
    private String numeroCartola;

    @JsonProperty("fechafinal")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy", timezone = "GMT-03:00")
    private String fechaFinal;

    @JsonProperty("crc")
    private String crc;

    @JsonProperty("fechainicial_date")
    private String fechaInicialDate;

    @JsonProperty("fechahoraemision_date")
    private String fechaHoraRmisionDate;

    @JsonProperty("fechafinal_date")
    private String fechaFinalDate;

    public String getNumeroCuentaCorriente() {
        return numeroCuentaCorriente;
    }

    public void setNumeroCuentaCorriente(String numeroCuentaCorriente) {
        this.numeroCuentaCorriente = numeroCuentaCorriente;
    }

    public Date getFechaInicial() {
        return fechaInicial;
    }

    public void setFechaInicial(Date fechaInicial) {
        this.fechaInicial = fechaInicial;
    }

    public String getRazonSocial() {
        return razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    public String getRut() {
        return rut;
    }

    public void setRut(String rut) {
        this.rut = rut;
    }

    public String getNombreCuenta() {
        return nombreCuenta;
    }

    public void setNombreCuenta(String nombreCuenta) {
        this.nombreCuenta = nombreCuenta;
    }

    public String getHolding() {
        return holding;
    }

    public void setHolding(String holding) {
        this.holding = holding;
    }

    public String getUnidadDeNegocio() {
        return unidadDeNegocio;
    }

    public void setUnidadDeNegocio(String unidadDeNegocio) {
        this.unidadDeNegocio = unidadDeNegocio;
    }

    public String getUsuarioConectado() {
        return usuarioConectado;
    }

    public void setUsuarioConectado(String usuarioConectado) {
        this.usuarioConectado = usuarioConectado;
    }

    public String getRol() {
        return rol;
    }

    public void setRol(String rol) {
        this.rol = rol;
    }

    public String getFechaHora() {
        return fechaHora;
    }

    public void setFechaHora(String fechaHora) {
        this.fechaHora = fechaHora;
    }

    public String getFechaHoraEmision() {
        return fechaHoraEmision;
    }

    public void setFechaHoraEmision(String fechaHoraEmision) {
        this.fechaHoraEmision = fechaHoraEmision;
    }

    public String getEjecutivo() {
        return ejecutivo;
    }

    public void setEjecutivo(String ejecutivo) {
        this.ejecutivo = ejecutivo;
    }

    public Integer getNumeroMovimientos() {
        return numeroMovimientos;
    }

    public void setNumeroMovimientos(Integer numeroMovimientos) {
        this.numeroMovimientos = numeroMovimientos;
    }

    public String getNumeroCartola() {
        return numeroCartola;
    }

    public void setNumeroCartola(String numeroCartola) {
        this.numeroCartola = numeroCartola;
    }

    public String getFechaFinal() {
        return fechaFinal;
    }

    public void setFechaFinal(String fechaFinal) {
        this.fechaFinal = fechaFinal;
    }

    public String getCrc() {
        return crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public String getFechaInicialDate() {
        return fechaInicialDate;
    }

    public void setFechaInicialDate(String fechaInicialDate) {
        this.fechaInicialDate = fechaInicialDate;
    }

    public String getFechaHoraRmisionDate() {
        return fechaHoraRmisionDate;
    }

    public void setFechaHoraRmisionDate(String fechaHoraRmisionDate) {
        this.fechaHoraRmisionDate = fechaHoraRmisionDate;
    }

    public String getFechaFinalDate() {
        return fechaFinalDate;
    }

    public void setFechaFinalDate(String fechaFinalDate) {
        this.fechaFinalDate = fechaFinalDate;
    }

    @Override
    public String toString() {
        return "Cabecera [" +
                ((numeroCuentaCorriente != null) ? "numeroCuentaCorriente='" + numeroCuentaCorriente + "', " : "") +
                ((fechaInicial != null) ? "fechaInicial=" + fechaInicial + ", " : "") +
                ((razonSocial != null) ? "razonSocial='" + razonSocial + "', " : "") +
                ((rut != null) ? "rut='" + rut + "', " : "") +
                ((nombreCuenta != null) ? "nombreCuenta='" + nombreCuenta + "', " : "") +
                ((holding != null) ? "holding='" + holding + "', " : "") +
                ((unidadDeNegocio != null) ? "unidadDeNegocio='" + unidadDeNegocio + "', " : "") +
                ((usuarioConectado != null) ? "usuarioConectado='" + usuarioConectado + "', " : "") +
                ((rol != null) ? "rol='" + rol + "', " : "") +
                ((fechaHora != null) ? "fechaHora='" + fechaHora + "', " : "") +
                ((fechaHoraEmision != null) ? "fechaHoraEmision='" + fechaHoraEmision + "', " : "") +
                ((ejecutivo != null) ? "ejecutivo='" + ejecutivo + "', " : "") +
                ((numeroMovimientos != null) ? "numeroMovimientos=" + numeroMovimientos + ", " : "") +
                ((numeroCartola != null) ? "numeroCartola='" + numeroCartola + "', " : "") +
                ((fechaFinal != null) ? "fechaFinal='" + fechaFinal + "', " : "") +
                ((crc != null) ? "crc='" + crc + "', " : "") +
                ((fechaInicialDate != null) ? "fechaInicialDate='" + fechaInicialDate + "', " : "") +
                ((fechaHoraRmisionDate != null) ? "fechaHoraRmisionDate='" + fechaHoraRmisionDate + "', " : "") +
                ((fechaFinalDate != null) ? "fechaFinalDate='" + fechaFinalDate + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cabecera cabecera = (Cabecera) o;
        return Objects.equals(numeroCuentaCorriente, cabecera.numeroCuentaCorriente) && Objects.equals(fechaInicial, cabecera.fechaInicial) && Objects.equals(razonSocial, cabecera.razonSocial) && Objects.equals(rut, cabecera.rut) && Objects.equals(nombreCuenta, cabecera.nombreCuenta) && Objects.equals(holding, cabecera.holding) && Objects.equals(unidadDeNegocio, cabecera.unidadDeNegocio) && Objects.equals(usuarioConectado, cabecera.usuarioConectado) && Objects.equals(rol, cabecera.rol) && Objects.equals(fechaHora, cabecera.fechaHora) && Objects.equals(fechaHoraEmision, cabecera.fechaHoraEmision) && Objects.equals(ejecutivo, cabecera.ejecutivo) && Objects.equals(numeroMovimientos, cabecera.numeroMovimientos) && Objects.equals(numeroCartola, cabecera.numeroCartola) && Objects.equals(fechaFinal, cabecera.fechaFinal) && Objects.equals(crc, cabecera.crc) && Objects.equals(fechaInicialDate, cabecera.fechaInicialDate) && Objects.equals(fechaHoraRmisionDate, cabecera.fechaHoraRmisionDate) && Objects.equals(fechaFinalDate, cabecera.fechaFinalDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numeroCuentaCorriente, fechaInicial, razonSocial, rut, nombreCuenta, holding, unidadDeNegocio, usuarioConectado, rol, fechaHora, fechaHoraEmision, ejecutivo, numeroMovimientos, numeroCartola, fechaFinal, crc, fechaInicialDate, fechaHoraRmisionDate, fechaFinalDate);
    }
}