package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class CommonResponse<T> implements Serializable {

    @JsonProperty("codigo")
    private Integer codigo;

    @JsonProperty("mensaje")
    private String mensaje;

    @JsonProperty("resultado")
    private String resultado;

    @JsonProperty("payload")
    private T payload;

    @JsonProperty("mensajeNegocio")
    private String mensajeNegocio;

    @JsonProperty("codigoOperacion")
    private String codigoOperacion;

    public Integer getCodigo() {
        return codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getMensaje() {
        return mensaje;
    }

    public void setMensaje(String mensaje) {
        this.mensaje = mensaje;
    }

    public String getResultado() {
        return resultado;
    }

    public void setResultado(String resultado) {
        this.resultado = resultado;
    }

    public T getPayload() {
        return payload;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public String getMensajeNegocio() {
        return mensajeNegocio;
    }

    public void setMensajeNegocio(String mensajeNegocio) {
        this.mensajeNegocio = mensajeNegocio;
    }

    public String getCodigoOperacion() {
        return codigoOperacion;
    }

    public void setCodigoOperacion(String codigoOperacion) {
        this.codigoOperacion = codigoOperacion;
    }

    @Override
    public String toString() {
        return toString("BaseResponse");
    }

    public String toString(String className) {
        return className + " [" +
                ((codigo != null) ? "codigo=" + codigo + ", " : "") +
                ((mensaje != null) ? "mensaje='" + mensaje + "', " : "") +
                ((resultado != null) ? "resultado='" + resultado + "', " : "") +
                ((payload != null) ? "payload='" + payload + "', " : "") +
                ((mensajeNegocio != null) ? "mensajeNegocio='" + mensajeNegocio + "', " : "") +
                ((codigoOperacion != null) ? "codigoOperacion='" + codigoOperacion + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonResponse that = (CommonResponse) o;
        return Objects.equals(codigo, that.codigo) && Objects.equals(mensaje, that.mensaje) && Objects.equals(resultado, that.resultado) && Objects.equals(mensajeNegocio, that.mensajeNegocio) && Objects.equals(codigoOperacion, that.codigoOperacion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(codigo, mensaje, resultado, mensajeNegocio, codigoOperacion);
    }
}