package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LoginRequest implements Serializable {

    @JsonProperty("password")
    private String password;

    @JsonProperty("switchND")
    private String switchND;

    @JsonProperty("ndsPmd")
    private String ndsPmd;

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSwitchND() {
        return switchND;
    }

    public void setSwitchND(String switchND) {
        this.switchND = switchND;
    }

    public String getNdsPmd() {
        return ndsPmd;
    }

    public void setNdsPmd(String ndsPmd) {
        this.ndsPmd = ndsPmd;
    }

    @Override
    public String toString() {
        return "LoginRequest [" +
                ((password != null) ? "password='" + password + "', " : "") +
                ((switchND != null) ? "switchND='" + switchND + "', " : "") +
                ((ndsPmd != null) ? "ndsPmd='" + ndsPmd + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoginRequest that = (LoginRequest) o;
        return Objects.equals(password, that.password) && Objects.equals(switchND, that.switchND) && Objects.equals(ndsPmd, that.ndsPmd);
    }

    @Override
    public int hashCode() {
        return Objects.hash(password, switchND, ndsPmd);
    }
}