package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostCartolasHistoricasRequest implements Serializable {

    @JsonProperty("numCuenta")
    private String numCuenta;
    // "IMj6ZNeQDSla+RnwXC2RGHRAwe75e+CqhfZX1N/p6nlbuqmteJRah6nGQRkJOibuynjN3qIGwXXcu6+UaTjtLadZWYHtK1zDnbjCCiv0+hdjNLD7CRasVo2aPIn/KZyrmUlIPlUGZQ1HRu90dSIeINN8AhLXze+53poLot51TzJnR+dRaY5BjekaBWhxCGgsup2g7Hy41OYSfyoKc5LIm2IzMmlQcZgkrJGTXzJqJDBVHQDBT1sPyBD/NrGLZ2HN7mxprBNNdsp1niqyhT8tXuOfioaoqALtDXA72OBaa4D9yXFhT2mwEE8+PXrpIMRBOqKhqcCPBtQ6BMe9G/aXxQ==
    @JsonProperty("fechaDesde")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaDesde;

    @JsonProperty("fechaHasta")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaHasta;

    @JsonProperty("correlativo")
    private Integer correlativo;

    public String getNumCuenta() {
        return numCuenta;
    }

    public void setNumCuenta(String numCuenta) {
        this.numCuenta = numCuenta;
    }

    public Date getFechaDesde() {
        return fechaDesde;
    }

    public void setFechaDesde(Date fechaDesde) {
        this.fechaDesde = fechaDesde;
    }

    public Date getFechaHasta() {
        return fechaHasta;
    }

    public void setFechaHasta(Date fechaHasta) {
        this.fechaHasta = fechaHasta;
    }

    public Integer getCorrelativo() {
        return correlativo;
    }

    public void setCorrelativo(Integer correlativo) {
        this.correlativo = correlativo;
    }

    @Override
    public String toString() {
        return "PostCartolasHistoricasRequest [" +
                ((numCuenta != null) ? "numCuenta='" + numCuenta + "', " : "") +
                ((fechaDesde != null) ? "fechaDesde=" + fechaDesde + ", " : "") +
                ((fechaHasta != null) ? "fechaHasta=" + fechaHasta + ", " : "") +
                ((correlativo != null) ? "correlativo=" + correlativo + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostCartolasHistoricasRequest that = (PostCartolasHistoricasRequest) o;
        return Objects.equals(numCuenta, that.numCuenta) && Objects.equals(fechaDesde, that.fechaDesde) && Objects.equals(fechaHasta, that.fechaHasta) && Objects.equals(correlativo, that.correlativo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numCuenta, fechaDesde, fechaHasta, correlativo);
    }
}