package ar.com.sdd.bancoestadoapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostDetalleCartolaRequest implements Serializable {

    @JsonProperty("numCartola")
    private Long numCartola;

    @JsonProperty("numCuenta")
    private String numCuenta;

    @JsonProperty("tipodescarga")
    private String tipoDescarga;

    public Long getNumCartola() {
        return numCartola;
    }

    public void setNumCartola(Long numCartola) {
        this.numCartola = numCartola;
    }

    public String getNumCuenta() {
        return numCuenta;
    }

    public void setNumCuenta(String numCuenta) {
        this.numCuenta = numCuenta;
    }

    public String getTipoDescarga() {
        return tipoDescarga;
    }

    public void setTipoDescarga(String tipoDescarga) {
        this.tipoDescarga = tipoDescarga;
    }

    @Override
    public String toString() {
        return "PostDetalleCartolaRequest [" +
                ((numCartola != null) ? "numCartola=" + numCartola + ", " : "") +
                ((numCuenta != null) ? "numCuenta='" + numCuenta + "', " : "") +
                ((tipoDescarga != null) ? "tipoDescarga='" + tipoDescarga + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostDetalleCartolaRequest that = (PostDetalleCartolaRequest) o;
        return Objects.equals(numCartola, that.numCartola) && Objects.equals(numCuenta, that.numCuenta) && Objects.equals(tipoDescarga, that.tipoDescarga);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numCartola, numCuenta, tipoDescarga);
    }
}