package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cartola implements Serializable {

    @JsonProperty("numCartola")
    private Long numCartola;

    @JsonProperty("numCuenta")
    private String numCuenta;

    @JsonProperty("nombreTitular")
    private String nombreTitular;

    @JsonProperty("rutEmpresa")
    private Long rutEmpresa;

    @JsonProperty("dvEmpresa")
    private String dvEmpresa;

    @JsonProperty("codigoCartola")
    private String codigoCartola;

    @JsonProperty("fechaEmision")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaEmision;

    @JsonProperty("cartolaFecha")
    private String cartolaFecha;

    @JsonProperty("fechaEmision_date")
    private String fechaEmision_date;

    @JsonProperty("numCartola_number")
    private Long numCartola_number;

    @JsonProperty("paginacionLink")
    private PaginationLink paginacionLink;

    public Long getNumCartola() {
        return numCartola;
    }

    public void setNumCartola(Long numCartola) {
        this.numCartola = numCartola;
    }

    public String getNumCuenta() {
        return numCuenta;
    }

    public void setNumCuenta(String numCuenta) {
        this.numCuenta = numCuenta;
    }

    public String getNombreTitular() {
        return nombreTitular;
    }

    public void setNombreTitular(String nombreTitular) {
        this.nombreTitular = nombreTitular;
    }

    public Long getRutEmpresa() {
        return rutEmpresa;
    }

    public void setRutEmpresa(Long rutEmpresa) {
        this.rutEmpresa = rutEmpresa;
    }

    public String getDvEmpresa() {
        return dvEmpresa;
    }

    public void setDvEmpresa(String dvEmpresa) {
        this.dvEmpresa = dvEmpresa;
    }

    public String getCodigoCartola() {
        return codigoCartola;
    }

    public void setCodigoCartola(String codigoCartola) {
        this.codigoCartola = codigoCartola;
    }

    public Date getFechaEmision() {
        return fechaEmision;
    }

    public void setFechaEmision(Date fechaEmision) {
        this.fechaEmision = fechaEmision;
    }

    public String getCartolaFecha() {
        return cartolaFecha;
    }

    public void setCartolaFecha(String cartolaFecha) {
        this.cartolaFecha = cartolaFecha;
    }

    public String getFechaEmision_date() {
        return fechaEmision_date;
    }

    public void setFechaEmision_date(String fechaEmision_date) {
        this.fechaEmision_date = fechaEmision_date;
    }

    public Long getNumCartola_number() {
        return numCartola_number;
    }

    public void setNumCartola_number(Long numCartola_number) {
        this.numCartola_number = numCartola_number;
    }

    public PaginationLink getPaginacionLink() {
        return paginacionLink;
    }

    public void setPaginacionLink(PaginationLink paginacionLink) {
        this.paginacionLink = paginacionLink;
    }

    @Override
    public String toString() {
        return "Cartola [" +
                ((numCartola != null) ? "numCartola=" + numCartola + ", " : "") +
                ((numCuenta != null) ? "numCuenta='" + numCuenta + "', " : "") +
                ((nombreTitular != null) ? "nombreTitular='" + nombreTitular + "', " : "") +
                ((rutEmpresa != null) ? "rutEmpresa=" + rutEmpresa + ", " : "") +
                ((dvEmpresa != null) ? "dvEmpresa='" + dvEmpresa + "', " : "") +
                ((codigoCartola != null) ? "codigoCartola='" + codigoCartola + "', " : "") +
                ((fechaEmision != null) ? "fechaEmision=" + fechaEmision + ", " : "") +
                ((cartolaFecha != null) ? "cartolaFecha='" + cartolaFecha + "', " : "") +
                ((fechaEmision_date != null) ? "fechaEmision_date='" + fechaEmision_date + "', " : "") +
                ((numCartola_number != null) ? "numCartola_number=" + numCartola_number + ", " : "") +
                ((paginacionLink != null) ? "paginacionLink=" + paginacionLink + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cartola cartola = (Cartola) o;
        return Objects.equals(numCartola, cartola.numCartola) && Objects.equals(numCuenta, cartola.numCuenta) && Objects.equals(nombreTitular, cartola.nombreTitular) && Objects.equals(rutEmpresa, cartola.rutEmpresa) && Objects.equals(dvEmpresa, cartola.dvEmpresa) && Objects.equals(codigoCartola, cartola.codigoCartola) && Objects.equals(fechaEmision, cartola.fechaEmision) && Objects.equals(cartolaFecha, cartola.cartolaFecha) && Objects.equals(fechaEmision_date, cartola.fechaEmision_date) && Objects.equals(numCartola_number, cartola.numCartola_number) && Objects.equals(paginacionLink, cartola.paginacionLink);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numCartola, numCuenta, nombreTitular, rutEmpresa, dvEmpresa, codigoCartola, fechaEmision, cartolaFecha, fechaEmision_date, numCartola_number, paginacionLink);
    }
}