package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CartolasHistoricasPayload implements Serializable {

    @JsonProperty("accountNumber")
    private String accountNumber;

    @JsonProperty("cartolaList")
    private List<Cartola> cartolas;

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public List<Cartola> getCartolas() {
        return cartolas;
    }

    public void setCartolas(List<Cartola> cartolas) {
        this.cartolas = cartolas;
    }

    @Override
    public String toString() {
        return "CartolasHistoricasPayload [" +
                ((accountNumber != null) ? "accountNumber='" + accountNumber + "', " : "") +
                ((cartolas != null) ? "cartolas=" + Arrays.toString(cartolas.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CartolasHistoricasPayload that = (CartolasHistoricasPayload) o;
        return Objects.equals(accountNumber, that.accountNumber) && Objects.equals(cartolas, that.cartolas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountNumber, cartolas);
    }
}