package ar.com.sdd.bancoestadoapi.model;

import ar.com.sdd.bancoestadoapi.io.Cabecera;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DetalleCartolaPayload implements Serializable {

    @JsonProperty("cabecera")
    private Cabecera cabecera;

    @JsonProperty("resumen")
    private Resumen resumen;

    @JsonProperty("movimientos")
    private List<Movimiento> movimientos;

    @JsonProperty("cantidad")
    private Integer cantidad;

    @JsonProperty("hayMas")
    private Boolean hayMas;

    public Cabecera getCabecera() {
        return cabecera;
    }

    public void setCabecera(Cabecera cabecera) {
        this.cabecera = cabecera;
    }

    public Resumen getResumen() {
        return resumen;
    }

    public void setResumen(Resumen resumen) {
        this.resumen = resumen;
    }

    public List<Movimiento> getMovimientos() {
        return movimientos;
    }

    public void setMovimientos(List<Movimiento> movimientos) {
        this.movimientos = movimientos;
    }

    public Integer getCantidad() {
        return cantidad;
    }

    public void setCantidad(Integer cantidad) {
        this.cantidad = cantidad;
    }

    public Boolean getHayMas() {
        return hayMas;
    }

    public void setHayMas(Boolean hayMas) {
        this.hayMas = hayMas;
    }

    @Override
    public String toString() {
        return "DetalleCartolaPayload [" +
                ((cabecera != null) ? "cabecera=" + cabecera + ", " : "") +
                ((resumen != null) ? "resumen=" + resumen + ", " : "") +
                ((movimientos != null) ? "movimientos=" + Arrays.toString(movimientos.toArray()) + ", " : "") +
                ((cantidad != null) ? "cantidad=" + cantidad + ", " : "") +
                ((hayMas != null) ? "hayMas=" + hayMas + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DetalleCartolaPayload that = (DetalleCartolaPayload) o;
        return Objects.equals(cabecera, that.cabecera) && Objects.equals(resumen, that.resumen) && Objects.equals(movimientos, that.movimientos) && Objects.equals(cantidad, that.cantidad) && Objects.equals(hayMas, that.hayMas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cabecera, resumen, movimientos, cantidad, hayMas);
    }
}