package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LoginPayload implements Serializable {

    @JsonProperty("jwt")
    private String jwt;

    @JsonProperty("headers")
    private Map<String, String> headers;

    @JsonProperty("primeraFC")
    private String primeraFC;

    @JsonProperty("user")
    private User user;

    @JsonProperty("piloto")
    private Boolean piloto;

    public String getJwt() {
        return jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getPrimeraFC() {
        return primeraFC;
    }

    public void setPrimeraFC(String primeraFC) {
        this.primeraFC = primeraFC;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Boolean getPiloto() {
        return piloto;
    }

    public void setPiloto(Boolean piloto) {
        this.piloto = piloto;
    }

    @Override
    public String toString() {
        return "LoginPayload [" +
                ((jwt != null) ? "jwt='" + jwt + "', " : "") +
                ((headers != null) ? "headers=" + headers + ", " : "") +
                ((primeraFC != null) ? "primeraFC='" + primeraFC + "', " : "") +
                ((user != null) ? "user=" + user + ", " : "") +
                ((piloto != null) ? "piloto=" + piloto + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoginPayload that = (LoginPayload) o;
        return Objects.equals(jwt, that.jwt) && Objects.equals(headers, that.headers) && Objects.equals(primeraFC, that.primeraFC) && Objects.equals(user, that.user) && Objects.equals(piloto, that.piloto);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jwt, headers, primeraFC, user, piloto);
    }
}