package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Movimiento implements Serializable {

    @JsonProperty("depositosabonosmovimiento")
    private String depositosAbonosMovimientoAsString;

    @JsonProperty("chequescargosmovimiento")
    private String chequesCargosMovimientoAsString;

    @JsonProperty("numerooperacionmovimiento")
    private String numeroOperacionMovimiento;

    @JsonProperty("fechamovimiento")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy", timezone = "GMT-03:00")
    private String fechaMovimiento;

    @JsonProperty("sucursalmovimiento")
    private String sucursalmovimiento;

    @JsonProperty("saldopormovimiento")
    private String saldoPorMovimientoAsString;

    @JsonProperty("fecmov")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy", timezone = "GMT-03:00")
    private String fecmov;

    @JsonProperty("descripcionmovimiento")
    private String descripcionMovimiento;

    @JsonProperty("crc")
    private String crc;

    @JsonProperty("glosadoc")
    private String glosaDoc;

    @JsonProperty("muestracomprobante")
    private MuestraComprobante muestraComprobante;

    @JsonProperty("link")
    private Boolean link;

    @JsonProperty("depositosabonosmovimiento_number")
    private BigDecimal depositosAbonosMovimiento;

    @JsonProperty("chequescargosmovimiento_number")
    private BigDecimal chequesCargosMovimiento;

    @JsonProperty("fechamovimiento_date")
    private String fechaMovimientoDate;

    @JsonProperty("saldopormovimiento_number")
    private BigDecimal saldoPorMovimiento;

    @JsonProperty("fecmov_date")
    private String fecmovDate;// "February 20, 2025"

    public String getDepositosAbonosMovimientoAsString() {
        return depositosAbonosMovimientoAsString;
    }

    public void setDepositosAbonosMovimientoAsString(String depositosAbonosMovimientoAsString) {
        this.depositosAbonosMovimientoAsString = depositosAbonosMovimientoAsString;
    }

    public String getChequesCargosMovimientoAsString() {
        return chequesCargosMovimientoAsString;
    }

    public void setChequesCargosMovimientoAsString(String chequesCargosMovimientoAsString) {
        this.chequesCargosMovimientoAsString = chequesCargosMovimientoAsString;
    }

    public String getNumeroOperacionMovimiento() {
        return numeroOperacionMovimiento;
    }

    public void setNumeroOperacionMovimiento(String numeroOperacionMovimiento) {
        this.numeroOperacionMovimiento = numeroOperacionMovimiento;
    }

    public String getFechaMovimiento() {
        return fechaMovimiento;
    }

    public void setFechaMovimiento(String fechaMovimiento) {
        this.fechaMovimiento = fechaMovimiento;
    }

    public String getSucursalmovimiento() {
        return sucursalmovimiento;
    }

    public void setSucursalmovimiento(String sucursalmovimiento) {
        this.sucursalmovimiento = sucursalmovimiento;
    }

    public String getSaldoPorMovimientoAsString() {
        return saldoPorMovimientoAsString;
    }

    public void setSaldoPorMovimientoAsString(String saldoPorMovimientoAsString) {
        this.saldoPorMovimientoAsString = saldoPorMovimientoAsString;
    }

    public String getFecmov() {
        return fecmov;
    }

    public void setFecmov(String fecmov) {
        this.fecmov = fecmov;
    }

    public String getDescripcionMovimiento() {
        return descripcionMovimiento;
    }

    public void setDescripcionMovimiento(String descripcionMovimiento) {
        this.descripcionMovimiento = descripcionMovimiento;
    }

    public String getCrc() {
        return crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public String getGlosaDoc() {
        return glosaDoc;
    }

    public void setGlosaDoc(String glosaDoc) {
        this.glosaDoc = glosaDoc;
    }

    public MuestraComprobante getMuestraComprobante() {
        return muestraComprobante;
    }

    public void setMuestraComprobante(MuestraComprobante muestraComprobante) {
        this.muestraComprobante = muestraComprobante;
    }

    public Boolean getLink() {
        return link;
    }

    public void setLink(Boolean link) {
        this.link = link;
    }

    public BigDecimal getDepositosAbonosMovimiento() {
        return depositosAbonosMovimiento;
    }

    public void setDepositosAbonosMovimiento(BigDecimal depositosAbonosMovimiento) {
        this.depositosAbonosMovimiento = depositosAbonosMovimiento;
    }

    public BigDecimal getChequesCargosMovimiento() {
        return chequesCargosMovimiento;
    }

    public void setChequesCargosMovimiento(BigDecimal chequesCargosMovimiento) {
        this.chequesCargosMovimiento = chequesCargosMovimiento;
    }

    public String getFechaMovimientoDate() {
        return fechaMovimientoDate;
    }

    public void setFechaMovimientoDate(String fechaMovimientoDate) {
        this.fechaMovimientoDate = fechaMovimientoDate;
    }

    public BigDecimal getSaldoPorMovimiento() {
        return saldoPorMovimiento;
    }

    public void setSaldoPorMovimiento(BigDecimal saldoPorMovimiento) {
        this.saldoPorMovimiento = saldoPorMovimiento;
    }

    public String getFecmovDate() {
        return fecmovDate;
    }

    public void setFecmovDate(String fecmovDate) {
        this.fecmovDate = fecmovDate;
    }

    @Override
    public String toString() {
        return "Movimiento [" +
                ((depositosAbonosMovimientoAsString != null) ? "depositosAbonosMovimientoAsString='" + depositosAbonosMovimientoAsString + "', " : "") +
                ((chequesCargosMovimientoAsString != null) ? "chequesCargosMovimientoAsString='" + chequesCargosMovimientoAsString + "', " : "") +
                ((numeroOperacionMovimiento != null) ? "numeroOperacionMovimiento='" + numeroOperacionMovimiento + "', " : "") +
                ((fechaMovimiento != null) ? "fechaMovimiento='" + fechaMovimiento + "', " : "") +
                ((sucursalmovimiento != null) ? "sucursalmovimiento='" + sucursalmovimiento + "', " : "") +
                ((saldoPorMovimientoAsString != null) ? "saldoPorMovimientoAsString='" + saldoPorMovimientoAsString + "', " : "") +
                ((fecmov != null) ? "fecmov='" + fecmov + "', " : "") +
                ((descripcionMovimiento != null) ? "descripcionMovimiento='" + descripcionMovimiento + "', " : "") +
                ((crc != null) ? "crc='" + crc + "', " : "") +
                ((glosaDoc != null) ? "glosaDoc='" + glosaDoc + "', " : "") +
                ((muestraComprobante != null) ? "muestraComprobante=" + muestraComprobante + ", " : "") +
                ((link != null) ? "link=" + link + ", " : "") +
                ((depositosAbonosMovimiento != null) ? "depositosAbonosMovimiento=" + depositosAbonosMovimiento + ", " : "") +
                ((chequesCargosMovimiento != null) ? "chequesCargosMovimiento=" + chequesCargosMovimiento + ", " : "") +
                ((fechaMovimientoDate != null) ? "fechaMovimientoDate='" + fechaMovimientoDate + "', " : "") +
                ((saldoPorMovimiento != null) ? "saldoPorMovimiento=" + saldoPorMovimiento + ", " : "") +
                ((fecmovDate != null) ? "fecmovDate='" + fecmovDate + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Movimiento that = (Movimiento) o;
        return Objects.equals(depositosAbonosMovimientoAsString, that.depositosAbonosMovimientoAsString) && Objects.equals(chequesCargosMovimientoAsString, that.chequesCargosMovimientoAsString) && Objects.equals(numeroOperacionMovimiento, that.numeroOperacionMovimiento) && Objects.equals(fechaMovimiento, that.fechaMovimiento) && Objects.equals(sucursalmovimiento, that.sucursalmovimiento) && Objects.equals(saldoPorMovimientoAsString, that.saldoPorMovimientoAsString) && Objects.equals(fecmov, that.fecmov) && Objects.equals(descripcionMovimiento, that.descripcionMovimiento) && Objects.equals(crc, that.crc) && Objects.equals(glosaDoc, that.glosaDoc) && Objects.equals(muestraComprobante, that.muestraComprobante) && Objects.equals(link, that.link) && Objects.equals(depositosAbonosMovimiento, that.depositosAbonosMovimiento) && Objects.equals(chequesCargosMovimiento, that.chequesCargosMovimiento) && Objects.equals(fechaMovimientoDate, that.fechaMovimientoDate) && Objects.equals(saldoPorMovimiento, that.saldoPorMovimiento) && Objects.equals(fecmovDate, that.fecmovDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(depositosAbonosMovimientoAsString, chequesCargosMovimientoAsString, numeroOperacionMovimiento, fechaMovimiento, sucursalmovimiento, saldoPorMovimientoAsString, fecmov, descripcionMovimiento, crc, glosaDoc, muestraComprobante, link, depositosAbonosMovimiento, chequesCargosMovimiento, fechaMovimientoDate, saldoPorMovimiento, fecmovDate);
    }
}