package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MuestraComprobante implements Serializable {

    @JsonProperty("chequePagado")
    private Boolean chequePagado;

    @JsonProperty("depositoConDocumentos")
    private Boolean depositoConDocumentos;

    @JsonProperty("depositoEfectivo")
    private Boolean depositoEfectivo;

    @JsonProperty("pagoCaptacion")
    private Boolean pagoCaptacion;

    @JsonProperty("pagoChequeDepositoCtaCte")
    private Boolean pagoChequeDepositoCtaCte;

    @JsonProperty("chequeProtestado")
    private Boolean chequeProtestado;

    @JsonProperty("transferencia")
    private Boolean transferencia;

    public Boolean getChequePagado() {
        return chequePagado;
    }

    public void setChequePagado(Boolean chequePagado) {
        this.chequePagado = chequePagado;
    }

    public Boolean getDepositoConDocumentos() {
        return depositoConDocumentos;
    }

    public void setDepositoConDocumentos(Boolean depositoConDocumentos) {
        this.depositoConDocumentos = depositoConDocumentos;
    }

    public Boolean getDepositoEfectivo() {
        return depositoEfectivo;
    }

    public void setDepositoEfectivo(Boolean depositoEfectivo) {
        this.depositoEfectivo = depositoEfectivo;
    }

    public Boolean getPagoCaptacion() {
        return pagoCaptacion;
    }

    public void setPagoCaptacion(Boolean pagoCaptacion) {
        this.pagoCaptacion = pagoCaptacion;
    }

    public Boolean getPagoChequeDepositoCtaCte() {
        return pagoChequeDepositoCtaCte;
    }

    public void setPagoChequeDepositoCtaCte(Boolean pagoChequeDepositoCtaCte) {
        this.pagoChequeDepositoCtaCte = pagoChequeDepositoCtaCte;
    }

    public Boolean getChequeProtestado() {
        return chequeProtestado;
    }

    public void setChequeProtestado(Boolean chequeProtestado) {
        this.chequeProtestado = chequeProtestado;
    }

    public Boolean getTransferencia() {
        return transferencia;
    }

    public void setTransferencia(Boolean transferencia) {
        this.transferencia = transferencia;
    }

    @Override
    public String toString() {
        return "MuestraComprobante [" +
                ((chequePagado != null) ? "chequePagado=" + chequePagado + ", " : "") +
                ((depositoConDocumentos != null) ? "depositoConDocumentos=" + depositoConDocumentos + ", " : "") +
                ((depositoEfectivo != null) ? "depositoEfectivo=" + depositoEfectivo + ", " : "") +
                ((pagoCaptacion != null) ? "pagoCaptacion=" + pagoCaptacion + ", " : "") +
                ((pagoChequeDepositoCtaCte != null) ? "pagoChequeDepositoCtaCte=" + pagoChequeDepositoCtaCte + ", " : "") +
                ((chequeProtestado != null) ? "chequeProtestado=" + chequeProtestado + ", " : "") +
                ((transferencia != null) ? "transferencia=" + transferencia + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MuestraComprobante that = (MuestraComprobante) o;
        return Objects.equals(chequePagado, that.chequePagado) && Objects.equals(depositoConDocumentos, that.depositoConDocumentos) && Objects.equals(depositoEfectivo, that.depositoEfectivo) && Objects.equals(pagoCaptacion, that.pagoCaptacion) && Objects.equals(pagoChequeDepositoCtaCte, that.pagoChequeDepositoCtaCte) && Objects.equals(chequeProtestado, that.chequeProtestado) && Objects.equals(transferencia, that.transferencia);
    }

    @Override
    public int hashCode() {
        return Objects.hash(chequePagado, depositoConDocumentos, depositoEfectivo, pagoCaptacion, pagoChequeDepositoCtaCte, chequeProtestado, transferencia);
    }
}