package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaginationLink implements Serializable {

    @JsonProperty("anterior")
    private Object anterior; // Puede venir false o un id numerico

    @JsonProperty("siguiente")
    private Object siguiente; // Puede venir false o un id numerico

    public Object getAnterior() {
        return anterior;
    }

    public void setAnterior(Object anterior) {
        this.anterior = anterior;
    }

    public Object getSiguiente() {
        return siguiente;
    }

    public void setSiguiente(Object siguiente) {
        this.siguiente = siguiente;
    }

    @Override
    public String toString() {
        return "PaginationLink [" +
                ((anterior != null) ? "anterior=" + anterior + ", " : "") +
                ((siguiente != null) ? "siguiente=" + siguiente + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaginationLink that = (PaginationLink) o;
        return Objects.equals(anterior, that.anterior) && Objects.equals(siguiente, that.siguiente);
    }

    @Override
    public int hashCode() {
        return Objects.hash(anterior, siguiente);
    }
}