package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PreLoginPayload implements Serializable {

    @JsonProperty("publicKey")
    private String publicKey;

    @JsonProperty("globalsessionid")
    private String globalsessionid;

    @JsonProperty("globalsessionidtime")
    private String globalsessionidtime;

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getGlobalsessionid() {
        return globalsessionid;
    }

    public void setGlobalsessionid(String globalsessionid) {
        this.globalsessionid = globalsessionid;
    }

    public String getGlobalsessionidtime() {
        return globalsessionidtime;
    }

    public void setGlobalsessionidtime(String globalsessionidtime) {
        this.globalsessionidtime = globalsessionidtime;
    }

    @Override
    public String toString() {
        return "PreLoginPayload [" +
                ((publicKey != null) ? "publicKey='" + publicKey + "', " : "") +
                ((globalsessionid != null) ? "globalsessionid='" + globalsessionid + "', " : "") +
                ((globalsessionidtime != null) ? "globalsessionidtime='" + globalsessionidtime + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PreLoginPayload that = (PreLoginPayload) o;
        return Objects.equals(publicKey, that.publicKey) && Objects.equals(globalsessionid, that.globalsessionid) && Objects.equals(globalsessionidtime, that.globalsessionidtime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(publicKey, globalsessionid, globalsessionidtime);
    }
}