package ar.com.sdd.bancoestadoapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Resumen implements Serializable {

    @JsonProperty("totalcargos")
    private String totalCargosAsString;

    @JsonProperty("totalabonos")
    private String totalAbonosAsString;

    @JsonProperty("saldocontableinicial")
    private String saldoContableInicialAsString;

    @JsonProperty("totalcheques")
    private String totalChequesAsString;

    @JsonProperty("totaldepositos")
    private String totalDepositosAsString;

    @JsonProperty("saldototal")
    private String saldoTotalAsString;

    @JsonProperty("crc")
    private String crc;

    @JsonProperty("totalcargos_number")
    private BigDecimal totalCargos;

    @JsonProperty("totalabonos_number")
    private BigDecimal totalAbonos;

    @JsonProperty("saldocontableinicial_number")
    private BigDecimal saldoContableinicial;

    @JsonProperty("totalcheques_number")
    private BigDecimal totalCheques;

    @JsonProperty("totaldepositos_number")
    private BigDecimal totalDepositos;

    @JsonProperty("saldototal_number")
    private BigDecimal saldoTotal;

    public String getTotalCargosAsString() {
        return totalCargosAsString;
    }

    public void setTotalCargosAsString(String totalCargosAsString) {
        this.totalCargosAsString = totalCargosAsString;
    }

    public String getTotalAbonosAsString() {
        return totalAbonosAsString;
    }

    public void setTotalAbonosAsString(String totalAbonosAsString) {
        this.totalAbonosAsString = totalAbonosAsString;
    }

    public String getSaldoContableInicialAsString() {
        return saldoContableInicialAsString;
    }

    public void setSaldoContableInicialAsString(String saldoContableInicialAsString) {
        this.saldoContableInicialAsString = saldoContableInicialAsString;
    }

    public String getTotalChequesAsString() {
        return totalChequesAsString;
    }

    public void setTotalChequesAsString(String totalChequesAsString) {
        this.totalChequesAsString = totalChequesAsString;
    }

    public String getTotalDepositosAsString() {
        return totalDepositosAsString;
    }

    public void setTotalDepositosAsString(String totalDepositosAsString) {
        this.totalDepositosAsString = totalDepositosAsString;
    }

    public String getSaldoTotalAsString() {
        return saldoTotalAsString;
    }

    public void setSaldoTotalAsString(String saldoTotalAsString) {
        this.saldoTotalAsString = saldoTotalAsString;
    }

    public String getCrc() {
        return crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public BigDecimal getTotalCargos() {
        return totalCargos;
    }

    public void setTotalCargos(BigDecimal totalCargos) {
        this.totalCargos = totalCargos;
    }

    public BigDecimal getTotalAbonos() {
        return totalAbonos;
    }

    public void setTotalAbonos(BigDecimal totalAbonos) {
        this.totalAbonos = totalAbonos;
    }

    public BigDecimal getSaldoContableinicial() {
        return saldoContableinicial;
    }

    public void setSaldoContableinicial(BigDecimal saldoContableinicial) {
        this.saldoContableinicial = saldoContableinicial;
    }

    public BigDecimal getTotalCheques() {
        return totalCheques;
    }

    public void setTotalCheques(BigDecimal totalCheques) {
        this.totalCheques = totalCheques;
    }

    public BigDecimal getTotalDepositos() {
        return totalDepositos;
    }

    public void setTotalDepositos(BigDecimal totalDepositos) {
        this.totalDepositos = totalDepositos;
    }

    public BigDecimal getSaldoTotal() {
        return saldoTotal;
    }

    public void setSaldoTotal(BigDecimal saldoTotal) {
        this.saldoTotal = saldoTotal;
    }

    @Override
    public String toString() {
        return "Resumen [" +
                ((totalCargosAsString != null) ? "totalCargosAsString='" + totalCargosAsString + "', " : "") +
                ((totalAbonosAsString != null) ? "totalAbonosAsString='" + totalAbonosAsString + "', " : "") +
                ((saldoContableInicialAsString != null) ? "saldoContableInicialAsString='" + saldoContableInicialAsString + "', " : "") +
                ((totalChequesAsString != null) ? "totalChequesAsString='" + totalChequesAsString + "', " : "") +
                ((totalDepositosAsString != null) ? "totalDepositosAsString='" + totalDepositosAsString + "', " : "") +
                ((saldoTotalAsString != null) ? "saldoTotalAsString='" + saldoTotalAsString + "', " : "") +
                ((crc != null) ? "crc='" + crc + "', " : "") +
                ((totalCargos != null) ? "totalCargos=" + totalCargos + ", " : "") +
                ((totalAbonos != null) ? "totalAbonos=" + totalAbonos + ", " : "") +
                ((saldoContableinicial != null) ? "saldoContableinicial=" + saldoContableinicial + ", " : "") +
                ((totalCheques != null) ? "totalCheques=" + totalCheques + ", " : "") +
                ((totalDepositos != null) ? "totalDepositos=" + totalDepositos + ", " : "") +
                ((saldoTotal != null) ? "saldoTotal=" + saldoTotal + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Resumen resumen = (Resumen) o;
        return Objects.equals(totalCargosAsString, resumen.totalCargosAsString) && Objects.equals(totalAbonosAsString, resumen.totalAbonosAsString) && Objects.equals(saldoContableInicialAsString, resumen.saldoContableInicialAsString) && Objects.equals(totalChequesAsString, resumen.totalChequesAsString) && Objects.equals(totalDepositosAsString, resumen.totalDepositosAsString) && Objects.equals(saldoTotalAsString, resumen.saldoTotalAsString) && Objects.equals(crc, resumen.crc) && Objects.equals(totalCargos, resumen.totalCargos) && Objects.equals(totalAbonos, resumen.totalAbonos) && Objects.equals(saldoContableinicial, resumen.saldoContableinicial) && Objects.equals(totalCheques, resumen.totalCheques) && Objects.equals(totalDepositos, resumen.totalDepositos) && Objects.equals(saldoTotal, resumen.saldoTotal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(totalCargosAsString, totalAbonosAsString, saldoContableInicialAsString, totalChequesAsString, totalDepositosAsString, saldoTotalAsString, crc, totalCargos, totalAbonos, saldoContableinicial, totalCheques, totalDepositos, saldoTotal);
    }
}