/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.bancoestadoapi.core;

import ar.com.sdd.bancoestadoapi.core.BancoEstadoFrontendApiConnectorContext;
import ar.com.sdd.bancoestadoapi.io.CommonError;
import ar.com.sdd.bancoestadoapi.io.LoginRequest;
import ar.com.sdd.bancoestadoapi.io.LoginResponse;
import ar.com.sdd.bancoestadoapi.io.PostCartolasHistoricasRequest;
import ar.com.sdd.bancoestadoapi.io.PostCartolasHistoricasResponse;
import ar.com.sdd.bancoestadoapi.io.PostDetalleCartolaRequest;
import ar.com.sdd.bancoestadoapi.io.PostDetalleCartolaResponse;
import ar.com.sdd.bancoestadoapi.io.PreLoginResponse;
import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import java.util.UUID;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BancoEstadoFrontendApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(BancoEstadoFrontendApiConnector.class);
    private final SimpleCache cache = SimpleCacheManager.getInstance().getCache(this.getClass().getName());
    private final RestConnector connector;
    private final String rutEmpresa;
    private final String rutPersona;
    private String authToken;
    private Etapa etapa;

    public BancoEstadoFrontendApiConnector(BancoEstadoFrontendApiConnectorContext context) {
        this.rutEmpresa = context.getRutEmpresa();
        this.rutPersona = context.getRutPersona();
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.connector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public PreLoginResponse preLogin() throws RestConnectorException {
        String path = "/home-nwe-publico-bff/prelogin";
        log.debug("[preLogin] Request GET por hacer pre login");
        this.etapa = Etapa.PRELOGIN;
        return (PreLoginResponse)this.connector.genericGet(null, PreLoginResponse.class, CommonError.class, "/home-nwe-publico-bff/prelogin");
    }

    public LoginResponse login(LoginRequest loginRequest) throws RestConnectorException {
        String path = "/home-nwe-publico-bff/login";
        log.debug("[login] Request POST por hacer login con {}", (Object)loginRequest);
        this.etapa = Etapa.LOGIN;
        return (LoginResponse)this.connector.genericPost((Object)loginRequest, LoginResponse.class, CommonError.class, "/home-nwe-publico-bff/login");
    }

    public PostCartolasHistoricasResponse postCartolasHistoricas(String authToken, PostCartolasHistoricasRequest postCartolasHistoricasRequest) throws RestConnectorException {
        String path = "/cct-cartolas-historica-pj-bff/historica/cartolas";
        log.debug("[getCartolasHistoricas] Request POST por obtener las cartolas historias con {}", (Object)postCartolasHistoricasRequest);
        this.etapa = Etapa.OBTENER_CARTOLAS_HISTORICAS;
        this.authToken = authToken;
        return (PostCartolasHistoricasResponse)this.connector.genericPost((Object)postCartolasHistoricasRequest, PostCartolasHistoricasResponse.class, CommonError.class, "/cct-cartolas-historica-pj-bff/historica/cartolas");
    }

    public PostDetalleCartolaResponse postDetalleCartola(String authToken, PostDetalleCartolaRequest postDetalleCartolaRequest) throws RestConnectorException {
        String path = "/cct-cartolas-historica-pj-bff/detalle-cartola";
        log.debug("[postDetalleCartola] Request POST por obtener el detalle de la cartolas con {}", (Object)postDetalleCartolaRequest);
        this.etapa = Etapa.OBTENER_DETALLE_CARTOLA;
        this.authToken = authToken;
        return (PostDetalleCartolaResponse)this.connector.genericPost((Object)postDetalleCartolaRequest, PostDetalleCartolaResponse.class, CommonError.class, "/cct-cartolas-historica-pj-bff/detalle-cartola");
    }

    private String getSessionCode() {
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"sessionCode"});
        String sessionCode = (String)this.cache.get(cacheKey);
        if (sessionCode == null) {
            sessionCode = UUID.randomUUID().toString();
            this.cache.put(cacheKey, (Object)sessionCode, Integer.valueOf(600));
        }
        return sessionCode;
    }

    private String getXTrackId() {
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"xTrackId"});
        String xTrackId = (String)this.cache.get(cacheKey);
        if (xTrackId == null) {
            xTrackId = UUID.randomUUID().toString();
            this.cache.put(cacheKey, (Object)xTrackId, Integer.valueOf(600));
        }
        return xTrackId;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("canal", (Object)"NWE");
            builder.header("codigosesion", (Object)this.getSessionCode());
            builder.header("dvempresa", (Object)"6");
            builder.header("dvpersona", (Object)"5");
            builder.header("rutempresa", (Object)this.rutEmpresa);
            builder.header("rutpersona", (Object)this.rutPersona);
            builder.header("xtrackid", (Object)this.getXTrackId());
            builder.header("User-Agent", (Object)"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36");
            builder.header("etapa", (Object)this.etapa.value);
            if (this.etapa.equals((Object)Etapa.PRELOGIN) || this.etapa.equals((Object)Etapa.LOGIN)) {
                builder.header("funcionalidad", (Object)"login");
                builder.header("topico", (Object)"WEBOMT");
            } else if (this.etapa.equals((Object)Etapa.OBTENER_CARTOLAS_HISTORICAS) || this.etapa.equals((Object)Etapa.OBTENER_DETALLE_CARTOLA)) {
                builder.header("funcionalidad", (Object)"SVXCCT005");
                builder.header("authorization", (Object)this.authToken);
            }
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    private static enum Etapa {
        PRELOGIN,
        LOGIN,
        OBTENER_CARTOLAS_HISTORICAS("BCHOCH"),
        OBTENER_DETALLE_CARTOLA("BCHODC");

        final String value;

        private Etapa() {
            this.value = this.name();
        }

        private Etapa(String value) {
            this.value = value;
        }
    }
}

