package ar.com.sdd.banconnector.cvuapi.api.alias

import ar.com.sdd.banconnector.cvuapi.model.AliasRequest
import ar.com.sdd.commons.rest.log.ServerFileLogged
import javax.inject.Inject
import javax.ws.rs.*
import javax.ws.rs.core.Context
import javax.ws.rs.core.Response
import javax.ws.rs.core.SecurityContext

@Path("/cvuapi/v1_0/alias")
open class AliasCvuApiEndpoint {

    @Inject
    private lateinit var aliasCvuApiService: AliasCvuApiService

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/alias")
    @Produces("application/json; charset=utf-8")
    open fun getCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, aliasRequest: AliasRequest?, @Context securityContext: SecurityContext?): Response {
        return aliasCvuApiService.getAlias(authorization, aid, ownerId, aliasRequest, securityContext)
    }

    @PUT
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/alias")
    @Produces("application/json; charset=utf-8")
    open fun putCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, aliasRequest: AliasRequest?, @Context securityContext: SecurityContext?): Response {
        return aliasCvuApiService.putAlias(authorization, aid, ownerId, aliasRequest, securityContext)
    }

}