package ar.com.sdd.banconnector.cvuapi.api.credit

import ar.com.sdd.banconnector.cvuapi.model.DebinListaRequest
import ar.com.sdd.commons.rest.log.ServerFileLogged
import javax.inject.Inject
import javax.ws.rs.*
import javax.ws.rs.core.Context
import javax.ws.rs.core.Response
import javax.ws.rs.core.SecurityContext

@Path("/cvuapi/v1_0/debin")
open class CreditCvuApiEndpoint {

    @Inject
    private lateinit var creditCvuApiService: CreditCvuApiService

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin/{debinId}")
    @Produces("application/json; charset=utf-8")
    open fun getDebin(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, @PathParam("debinId") debinId: String?, @Context securityContext: SecurityContext?): Response {
        return creditCvuApiService.getDebin(authorization, aid, ownerId, debinId, securityContext)
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin/lista")
    @Produces("application/json; charset=utf-8")
    open fun getDebinLista(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, debinListaRequest: DebinListaRequest?, @Context securityContext: SecurityContext?): Response {
        return creditCvuApiService.getDebinLista(authorization, aid, ownerId, debinListaRequest, securityContext)
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/avisoCvu")
    @Produces("application/json; charset=utf-8")
    open fun getAvisoCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, @QueryParam("trackingNumber") trackingNumber: Long?, @Context securityContext: SecurityContext?): Response {
        return creditCvuApiService.getAvisoCvu(authorization, aid, ownerId, trackingNumber, securityContext)
    }

}