package ar.com.sdd.banconnector.cvuapi.api.cvu

import ar.com.sdd.commons.rest.log.ServerFileLogged
import ar.com.sdd.debin.entity.Cvu
import javax.inject.Inject
import javax.ws.rs.*
import javax.ws.rs.core.Context
import javax.ws.rs.core.Response
import javax.ws.rs.core.SecurityContext

@Path("/cvuapi/v1_0/cvu")
open class CvuCvuApiEndpoint {

    @Inject
    private lateinit var cvuCvuApiService: CvuCvuApiService

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/cvu/{cvu}")
    @Produces("application/json; charset=utf-8")
    open fun getCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, @PathParam("cvu") cvu: String?, @Context securityContext: SecurityContext?): Response {
        return cvuCvuApiService.getCvu(authorization, aid, ownerId, cvu, securityContext)
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/cvu/find")
    @Produces("application/json; charset=utf-8")
    open fun findCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, @QueryParam("cuit") cuit: String?, @Context securityContext: SecurityContext?): Response {
        return cvuCvuApiService.findCvu(authorization, aid, ownerId, cuit, securityContext)
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/cvu")
    @Consumes("application/json")
    @Produces("application/json; charset=utf-8")
        open fun postCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, cvuRequest: Cvu?, @Context securityContext: SecurityContext?): Response {
        return cvuCvuApiService.postCvu(authorization, aid, ownerId, cvuRequest, securityContext)
    }

    @PUT
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/cvu/{cvu}")
    @Produces("application/json; charset=utf-8")
    open fun putCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, @PathParam("cvu") cvu: String?, @Context securityContext: SecurityContext?): Response {
        return cvuCvuApiService.putCvu(authorization, aid, ownerId, cvu, securityContext)
    }

    @DELETE
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/cvu/{cvu}")
    @Produces("application/json; charset=utf-8")
    open fun deleteCvu(@HeaderParam("Authorization") authorization: String?, @PathParam("aid") aid: String?, @PathParam("ownerId") ownerId: String?, @PathParam("cvu") cvu: String?, @Context securityContext: SecurityContext?): Response {
        return cvuCvuApiService.deleteCvu(authorization, aid, ownerId, cvu, securityContext)
    }

}