package ar.com.sdd.banconnector.debin.api.server.rest;


import ar.com.sdd.banconnector.debin.api.server.model.DebinInstructionSet;
import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import java.util.Date;

@Path("/debin")
public class DebinApi {

    @Inject
    private DebinApiService service;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debin-instructions")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postDebinInstructions(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, DebinInstructionSet debinInstructionSet, @Context SecurityContext securityContext) {
        return service.postDebinInstructions(authorization, aid, ownerId, debinInstructionSet, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debines")
    @Produces("application/json; charset=utf-8")
    public Response getDebin(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId,
                             @QueryParam("fromCreationDate") Date fromCreationDate, @QueryParam("toCreationDate") Date toCreationDate,
                             @QueryParam("fromExecutionDate") Date fromExecutionDate, @QueryParam("toExecutionDate") Date toExecutionDate,
                             @QueryParam("debinId") String debinId,
                             @Context SecurityContext securityContext) {
        return service.getDebin(authorization, aid, ownerId, fromCreationDate, toCreationDate, fromCreationDate, toExecutionDate, debinId, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/debines/{instructionId}")
    @Produces("application/json; charset=utf-8")
    public Response getDebin(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("instructionId") String instructionId, @Context SecurityContext securityContext) {
        return service.getDebin(authorization, aid, ownerId, instructionId, securityContext);
    }

}
