package ar.com.sdd.banconnector.debin.api.server.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DebinSet implements Serializable {

    private List<Debin> debines = new ArrayList<Debin>();
    private String message;

    public DebinSet() {

    }

    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty("debines")
    public List<Debin> getDebines() {
        return debines;
    }

    public void setDebines(List<Debin> debines) {
        this.debines = debines;
    }

    @Override
    public String toString() {
        return "DebinSet ["
                + ((debines != null) ? "debines=" + Arrays.toString(debines.toArray()) + ", " : "")
                + ((message != null) ? "message=" + message : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DebinSet debinSet = (DebinSet) o;

        if (debines != null ? !debines.equals(debinSet.debines) : debinSet.debines != null) return false;
        return message != null ? message.equals(debinSet.message) : debinSet.message == null;
    }

    @Override
    public int hashCode() {
        int result = debines != null ? debines.hashCode() : 0;
        result = 31 * result + (message != null ? message.hashCode() : 0);
        return result;
    }
}

